import { cx, css } from '@emotion/css';
import React__default, { useState, useCallback, useRef, useImperativeHandle } from 'react';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import { getFocusStyles } from '../../themes/mixins.js';
import { Icon } from '../Icon/Icon.js';
import { SubMenu } from './SubMenu.js';

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
const MenuItem = React__default.memo(
  React__default.forwardRef((props, ref) => {
    const {
      url,
      icon,
      label,
      ariaLabel,
      ariaChecked,
      target,
      onClick,
      className,
      active,
      disabled,
      destructive,
      childItems,
      role = "menuitem",
      tabIndex = -1,
      customSubMenuContainerStyles,
      shortcut,
      testId
    } = props;
    const styles = useStyles2(getStyles);
    const [isActive, setIsActive] = useState(active);
    const [isSubMenuOpen, setIsSubMenuOpen] = useState(false);
    const [openedWithArrow, setOpenedWithArrow] = useState(false);
    const onMouseEnter = useCallback(() => {
      if (disabled) {
        return;
      }
      setIsSubMenuOpen(true);
      setIsActive(true);
    }, [disabled]);
    const onMouseLeave = useCallback(() => {
      if (disabled) {
        return;
      }
      setIsSubMenuOpen(false);
      setIsActive(false);
    }, [disabled]);
    const hasSubMenu = childItems && childItems.length > 0;
    const ItemElement = hasSubMenu ? "div" : url === void 0 ? "button" : "a";
    const itemStyle = cx(
      {
        [styles.item]: true,
        [styles.active]: isActive,
        [styles.disabled]: disabled,
        [styles.destructive]: destructive && !disabled
      },
      className
    );
    const disabledProps = __spreadValues(__spreadValues({
      [ItemElement === "button" ? "disabled" : "aria-disabled"]: disabled
    }, ItemElement === "a" && disabled && { href: void 0, onClick: void 0 }), disabled && {
      tabIndex: -1,
      ["data-disabled"]: disabled
      // used to identify disabled items in Menu.tsx
    });
    const localRef = useRef(null);
    useImperativeHandle(ref, () => localRef.current);
    const handleKeys = (event) => {
      switch (event.key) {
        case "ArrowRight":
          event.preventDefault();
          event.stopPropagation();
          if (hasSubMenu) {
            setIsSubMenuOpen(true);
            setOpenedWithArrow(true);
            setIsActive(true);
          }
          break;
      }
    };
    const closeSubMenu = () => {
      var _a;
      setIsSubMenuOpen(false);
      setIsActive(false);
      (_a = localRef == null ? void 0 : localRef.current) == null ? void 0 : _a.focus();
    };
    const hasShortcut = Boolean(shortcut && shortcut.length > 0);
    return /* @__PURE__ */ React__default.createElement(
      ItemElement,
      __spreadValues({
        target,
        className: itemStyle,
        rel: target === "_blank" ? "noopener noreferrer" : void 0,
        href: url,
        onClick,
        onMouseEnter,
        onMouseLeave,
        onKeyDown: handleKeys,
        role: url === void 0 ? role : void 0,
        "data-role": "menuitem",
        ref: localRef,
        "data-testid": testId,
        "aria-label": ariaLabel,
        "aria-checked": ariaChecked,
        tabIndex
      }, disabledProps),
      /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, icon && /* @__PURE__ */ React__default.createElement(Icon, { name: icon, className: styles.icon, "aria-hidden": true }), label, /* @__PURE__ */ React__default.createElement("div", { className: cx(styles.rightWrapper, { [styles.withShortcut]: hasShortcut }) }, hasShortcut && /* @__PURE__ */ React__default.createElement("div", { className: styles.shortcut }, /* @__PURE__ */ React__default.createElement(Icon, { name: "keyboard", "aria-hidden": true }), shortcut), hasSubMenu && /* @__PURE__ */ React__default.createElement(
        SubMenu,
        {
          items: childItems,
          isOpen: isSubMenuOpen,
          openedWithArrow,
          setOpenedWithArrow,
          close: closeSubMenu,
          customStyle: customSubMenuContainerStyles
        }
      )))
    );
  })
);
MenuItem.displayName = "MenuItem";
const getStyles = (theme) => {
  return {
    item: css`
      background: none;
      cursor: pointer;
      white-space: nowrap;
      color: ${theme.colors.text.primary};
      display: flex;
      align-items: center;
      padding: ${theme.spacing(0.5, 2)};
      min-height: ${theme.spacing(4)};
      margin: 0;
      border: none;
      width: 100%;
      position: relative;

      &:hover,
      &:focus,
      &:focus-visible {
        background: ${theme.colors.action.hover};
        color: ${theme.colors.text.primary};
        text-decoration: none;
      }

      &:focus-visible {
        ${getFocusStyles(theme)}
      }
    `,
    active: css`
      background: ${theme.colors.action.hover};
    `,
    destructive: css`
      color: ${theme.colors.error.text};

      svg {
        color: ${theme.colors.error.text};
      }

      &:hover,
      &:focus,
      &:focus-visible {
        background: ${theme.colors.error.main};
        color: ${theme.colors.error.contrastText};

        svg {
          color: ${theme.colors.error.contrastText};
        }
      }
    `,
    disabled: css`
      color: ${theme.colors.action.disabledText};

      &:hover,
      &:focus,
      &:focus-visible {
        cursor: not-allowed;
        background: none;
        color: ${theme.colors.action.disabledText};
      }
    `,
    icon: css`
      opacity: 0.7;
      margin-right: 10px;
      margin-left: -4px;
      color: ${theme.colors.text.secondary};
    `,
    rightWrapper: css`
      display: flex;
      align-items: center;
      margin-left: auto;
    `,
    shortcutIcon: css`
      margin-right: ${theme.spacing(1)};
    `,
    withShortcut: css`
      min-width: ${theme.spacing(10.5)};
    `,
    shortcut: css`
      display: flex;
      align-items: center;
      gap: ${theme.spacing(1)};
      margin-left: ${theme.spacing(2)};
      color: ${theme.colors.text.secondary};
      opacity: 0.7;
    `
  };
};

export { MenuItem };
//# sourceMappingURL=MenuItem.js.map
