import memoizeOne from 'memoize-one';
import { getParser, FieldType } from '@grafana/data';
import { MAX_CHARACTERS } from './LogRowMessage.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const memoizedGetParser = memoizeOne(getParser);
const getAllFields = memoizeOne(
  (row, getFieldLinks) => {
    const logMessageFields = parseMessage(row.entry);
    const dataframeFields = getDataframeFields(row, getFieldLinks);
    const fieldsMap = [...dataframeFields, ...logMessageFields].reduce((acc, field) => {
      const value = field.value.replace(/(^")|("$)/g, "");
      const fieldHash = `${field.key}=${value}`;
      if (acc[fieldHash]) {
        acc[fieldHash].links = [...acc[fieldHash].links || [], ...field.links || []];
      } else {
        acc[fieldHash] = field;
      }
      return acc;
    }, {});
    const allFields = Object.values(fieldsMap);
    allFields.sort(sortFieldsLinkFirst);
    return allFields;
  }
);
const parseMessage = memoizeOne((rowEntry) => {
  if (rowEntry.length > MAX_CHARACTERS) {
    return [];
  }
  const parser = memoizedGetParser(rowEntry);
  if (!parser) {
    return [];
  }
  const detectedFields = parser.getFields(rowEntry);
  const fields = detectedFields.map((field) => {
    const key = parser.getLabelFromField(field);
    const value = parser.getValueFromField(field);
    return { key, value };
  });
  return fields;
});
const getDataframeFields = memoizeOne(
  (row, getFieldLinks) => {
    return row.dataFrame.fields.map((field, index) => __spreadProps(__spreadValues({}, field), { index })).filter((field, index) => !shouldRemoveField(field, index, row)).map((field) => {
      const links = getFieldLinks ? getFieldLinks(field, row.rowIndex) : [];
      return {
        key: field.name,
        value: field.values.get(row.rowIndex).toString(),
        links,
        fieldIndex: field.index
      };
    });
  }
);
function sortFieldsLinkFirst(fieldA, fieldB) {
  var _a, _b, _c, _d;
  if (((_a = fieldA.links) == null ? void 0 : _a.length) && !((_b = fieldB.links) == null ? void 0 : _b.length)) {
    return -1;
  }
  if (!((_c = fieldA.links) == null ? void 0 : _c.length) && ((_d = fieldB.links) == null ? void 0 : _d.length)) {
    return 1;
  }
  return fieldA.key > fieldB.key ? 1 : fieldA.key < fieldB.key ? -1 : 0;
}
function shouldRemoveField(field, index, row) {
  var _a;
  if (field.name === "labels" && field.type === FieldType.other) {
    return true;
  }
  if (field.name === "id") {
    return true;
  }
  if (row.entryFieldIndex === index) {
    return true;
  }
  if ((_a = field.config.custom) == null ? void 0 : _a.hidden) {
    return true;
  }
  if (field.values.get(row.rowIndex) == null) {
    return true;
  }
  return false;
}

export { getAllFields };
//# sourceMappingURL=logParser.js.map
