import memoizeOne from 'memoize-one';
import React__default, { PureComponent } from 'react';
import { sortLogRows, LogsDedupStrategy } from '@grafana/data';
import { withTheme2 } from '../../themes/ThemeContext.js';
import '@emotion/react';
import 'tinycolor2';
import { LogRow } from './LogRow.js';
import { getLogRowStyles } from './getLogRowStyles.js';

const PREVIEW_LIMIT = 100;
class UnThemedLogRows extends PureComponent {
  constructor() {
    super(...arguments);
    this.renderAllTimer = null;
    this.state = {
      renderAll: false
    };
    this.makeGetRows = memoizeOne((orderedRows) => {
      return () => orderedRows;
    });
    this.sortLogs = memoizeOne(
      (logRows, logsSortOrder) => sortLogRows(logRows, logsSortOrder)
    );
  }
  componentDidMount() {
    const { logRows, previewLimit } = this.props;
    const rowCount = logRows ? logRows.length : 0;
    const renderAll = rowCount <= previewLimit * 2;
    if (renderAll) {
      this.setState({ renderAll });
    } else {
      this.renderAllTimer = window.setTimeout(() => this.setState({ renderAll: true }), 2e3);
    }
  }
  componentWillUnmount() {
    if (this.renderAllTimer) {
      clearTimeout(this.renderAllTimer);
    }
  }
  render() {
    const {
      dedupStrategy,
      showContextToggle,
      showLabels,
      showTime,
      wrapLogMessage,
      prettifyLogMessage,
      logRows,
      deduplicatedRows,
      timeZone,
      onClickFilterLabel,
      onClickFilterOutLabel,
      theme,
      enableLogDetails,
      previewLimit,
      getFieldLinks,
      logsSortOrder,
      showDetectedFields,
      onClickShowDetectedField,
      onClickHideDetectedField,
      forceEscape,
      onLogRowHover
    } = this.props;
    const { renderAll } = this.state;
    const { logsRowsTable } = getLogRowStyles(theme);
    const dedupedRows = deduplicatedRows ? deduplicatedRows : logRows;
    const hasData = logRows && logRows.length > 0;
    const dedupCount = dedupedRows ? dedupedRows.reduce((sum, row) => row.duplicates ? sum + row.duplicates : sum, 0) : 0;
    const showDuplicates = dedupStrategy !== LogsDedupStrategy.none && dedupCount > 0;
    const processedRows = dedupedRows ? dedupedRows : [];
    const orderedRows = logsSortOrder ? this.sortLogs(processedRows, logsSortOrder) : processedRows;
    const firstRows = orderedRows.slice(0, previewLimit);
    const lastRows = orderedRows.slice(previewLimit, orderedRows.length);
    const getRows = this.makeGetRows(orderedRows);
    const getRowContext = this.props.getRowContext ? this.props.getRowContext : () => Promise.resolve([]);
    return /* @__PURE__ */ React__default.createElement("table", { className: logsRowsTable }, /* @__PURE__ */ React__default.createElement("tbody", null, hasData && firstRows.map((row, index) => /* @__PURE__ */ React__default.createElement(
      LogRow,
      {
        key: row.uid,
        getRows,
        getRowContext,
        row,
        showContextToggle,
        showDuplicates,
        showLabels,
        showTime,
        showDetectedFields,
        wrapLogMessage,
        prettifyLogMessage,
        timeZone,
        enableLogDetails,
        onClickFilterLabel,
        onClickFilterOutLabel,
        onClickShowDetectedField,
        onClickHideDetectedField,
        getFieldLinks,
        logsSortOrder,
        forceEscape,
        onLogRowHover
      }
    )), hasData && renderAll && lastRows.map((row, index) => /* @__PURE__ */ React__default.createElement(
      LogRow,
      {
        key: row.uid,
        getRows,
        getRowContext,
        row,
        showContextToggle,
        showDuplicates,
        showLabels,
        showTime,
        showDetectedFields,
        wrapLogMessage,
        prettifyLogMessage,
        timeZone,
        enableLogDetails,
        onClickFilterLabel,
        onClickFilterOutLabel,
        onClickShowDetectedField,
        onClickHideDetectedField,
        getFieldLinks,
        logsSortOrder,
        forceEscape,
        onLogRowHover
      }
    )), hasData && !renderAll && /* @__PURE__ */ React__default.createElement("tr", null, /* @__PURE__ */ React__default.createElement("td", { colSpan: 5 }, "Rendering ", orderedRows.length - previewLimit, " rows..."))));
  }
}
UnThemedLogRows.defaultProps = {
  previewLimit: PREVIEW_LIMIT
};
const LogRows = withTheme2(UnThemedLogRows);
LogRows.displayName = "LogsRows";

export { LogRows, PREVIEW_LIMIT };
//# sourceMappingURL=LogRows.js.map
