import { cx, css } from '@emotion/css';
import React__default, { PureComponent } from 'react';
import { dateTimeFormat, checkLogsError, escapeUnescapedString } from '@grafana/data';
import { withTheme2 } from '../../themes/ThemeContext.js';
import 'memoize-one';
import '@emotion/react';
import { hoverColor } from '../../themes/mixins.js';
import { Icon } from '../Icon/Icon.js';
import { Tooltip } from '../Tooltip/Tooltip.js';
import { LogDetails } from './LogDetails.js';
import { LogLabels } from './LogLabels.js';
import { LogRowContextProvider } from './LogRowContextProvider.js';
import { LogRowMessage } from './LogRowMessage.js';
import { LogRowMessageDetectedFields } from './LogRowMessageDetectedFields.js';
import { getLogRowStyles } from './getLogRowStyles.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const getStyles = (theme) => {
  return {
    topVerticalAlign: css`
      label: topVerticalAlign;
      margin-top: -${theme.spacing(0.9)};
      margin-left: -${theme.spacing(0.25)};
    `,
    detailsOpen: css`
      &:hover {
        background-color: ${hoverColor(theme.colors.background.primary, theme)};
      }
    `,
    errorLogRow: css`
      label: erroredLogRow;
      color: ${theme.colors.text.secondary};
    `
  };
};
class UnThemedLogRow extends PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      showContext: false,
      showDetails: false
    };
    this.toggleContext = () => {
      this.setState((state) => {
        return {
          showContext: !state.showContext
        };
      });
    };
    this.toggleDetails = () => {
      if (!this.props.enableLogDetails) {
        return;
      }
      this.setState((state) => {
        return {
          showDetails: !state.showDetails
        };
      });
    };
  }
  renderTimeStamp(epochMs) {
    return dateTimeFormat(epochMs, {
      timeZone: this.props.timeZone
    });
  }
  renderLogRow(context, errors, hasMoreContextRows, updateLimit) {
    const {
      getRows,
      onClickFilterLabel,
      onClickFilterOutLabel,
      onClickShowDetectedField,
      onClickHideDetectedField,
      enableLogDetails,
      row,
      showDuplicates,
      showContextToggle,
      showLabels,
      showTime,
      showDetectedFields,
      wrapLogMessage,
      prettifyLogMessage,
      theme,
      getFieldLinks,
      forceEscape,
      onLogRowHover
    } = this.props;
    const { showDetails, showContext } = this.state;
    const style = getLogRowStyles(theme, row.logLevel);
    const styles = getStyles(theme);
    const { errorMessage, hasError } = checkLogsError(row);
    const logRowBackground = cx(style.logsRow, {
      [styles.errorLogRow]: hasError
    });
    const processedRow = row.hasUnescapedContent && forceEscape ? __spreadProps(__spreadValues({}, row), { entry: escapeUnescapedString(row.entry), raw: escapeUnescapedString(row.raw) }) : row;
    return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, /* @__PURE__ */ React__default.createElement(
      "tr",
      {
        className: logRowBackground,
        onClick: this.toggleDetails,
        onMouseEnter: () => {
          onLogRowHover && onLogRowHover(row);
        },
        onMouseLeave: () => {
          onLogRowHover && onLogRowHover(void 0);
        }
      },
      showDuplicates && /* @__PURE__ */ React__default.createElement("td", { className: style.logsRowDuplicates }, processedRow.duplicates && processedRow.duplicates > 0 ? `${processedRow.duplicates + 1}x` : null),
      /* @__PURE__ */ React__default.createElement("td", { className: cx({ [style.logsRowLevel]: !hasError }) }, hasError && /* @__PURE__ */ React__default.createElement(Tooltip, { content: `Error: ${errorMessage}`, placement: "right", theme: "error" }, /* @__PURE__ */ React__default.createElement(Icon, { className: style.logIconError, name: "exclamation-triangle", size: "xs" }))),
      enableLogDetails && /* @__PURE__ */ React__default.createElement("td", { title: showDetails ? "Hide log details" : "See log details", className: style.logsRowToggleDetails }, /* @__PURE__ */ React__default.createElement(Icon, { className: styles.topVerticalAlign, name: showDetails ? "angle-down" : "angle-right" })),
      showTime && /* @__PURE__ */ React__default.createElement("td", { className: style.logsRowLocalTime }, this.renderTimeStamp(row.timeEpochMs)),
      showLabels && processedRow.uniqueLabels && /* @__PURE__ */ React__default.createElement("td", { className: style.logsRowLabels }, /* @__PURE__ */ React__default.createElement(LogLabels, { labels: processedRow.uniqueLabels })),
      showDetectedFields && showDetectedFields.length > 0 ? /* @__PURE__ */ React__default.createElement(
        LogRowMessageDetectedFields,
        {
          row: processedRow,
          showDetectedFields,
          getFieldLinks,
          wrapLogMessage
        }
      ) : /* @__PURE__ */ React__default.createElement(
        LogRowMessage,
        {
          row: processedRow,
          getRows,
          errors,
          hasMoreContextRows,
          updateLimit,
          context,
          contextIsOpen: showContext,
          showContextToggle,
          wrapLogMessage,
          prettifyLogMessage,
          onToggleContext: this.toggleContext
        }
      )
    ), this.state.showDetails && /* @__PURE__ */ React__default.createElement(
      LogDetails,
      {
        className: logRowBackground,
        showDuplicates,
        getFieldLinks,
        onClickFilterLabel,
        onClickFilterOutLabel,
        onClickShowDetectedField,
        onClickHideDetectedField,
        getRows,
        row: processedRow,
        wrapLogMessage,
        hasError,
        showDetectedFields
      }
    ));
  }
  render() {
    const { showContext } = this.state;
    const { logsSortOrder, row, getRowContext } = this.props;
    if (showContext) {
      return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, /* @__PURE__ */ React__default.createElement(LogRowContextProvider, { row, getRowContext, logsSortOrder }, ({ result, errors, hasMoreContextRows, updateLimit }) => {
        return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, this.renderLogRow(result, errors, hasMoreContextRows, updateLimit));
      }));
    }
    return this.renderLogRow();
  }
}
const LogRow = withTheme2(UnThemedLogRow);
LogRow.displayName = "LogRow";

export { LogRow };
//# sourceMappingURL=LogRow.js.map
