import { css } from '@emotion/css';
import React__default from 'react';
import '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';
import { CustomScrollbar } from '../CustomScrollbar/CustomScrollbar.js';
import { VizLegend } from '../VizLegend/VizLegend.js';
import { Graph } from './Graph.js';

const getGraphWithLegendStyles = stylesFactory(({ placement }) => ({
  wrapper: css`
    display: flex;
    flex-direction: ${placement === "bottom" ? "column" : "row"};
  `,
  graphContainer: css`
    min-height: 65%;
    flex-grow: 1;
  `,
  legendContainer: css`
    padding: 10px 0;
    max-height: ${placement === "bottom" ? "35%" : "none"};
  `
}));
const shouldHideLegendItem = (data, hideEmpty = false, hideZero = false) => {
  const isZeroOnlySeries = data.reduce((acc, current) => acc + (current[1] || 0), 0) === 0;
  const isNullOnlySeries = !data.reduce((acc, current) => acc && current[1] !== null, true);
  return hideEmpty && isNullOnlySeries || hideZero && isZeroOnlySeries;
};
const GraphWithLegend = (props) => {
  const {
    series,
    timeRange,
    width,
    height,
    showBars,
    showLines,
    showPoints,
    sortLegendBy,
    sortLegendDesc,
    legendDisplayMode,
    legendVisibility,
    placement,
    onSeriesToggle,
    onToggleSort,
    hideEmpty,
    hideZero,
    isStacked,
    lineWidth,
    onHorizontalRegionSelected,
    timeZone,
    children,
    ariaLabel
  } = props;
  const { graphContainer, wrapper, legendContainer } = getGraphWithLegendStyles(props);
  const legendItems = series.reduce((acc, s) => {
    return shouldHideLegendItem(s.data, hideEmpty, hideZero) ? acc : acc.concat([
      {
        label: s.label,
        color: s.color || "",
        disabled: !s.isVisible,
        yAxis: s.yAxis.index,
        getDisplayValues: () => s.info || []
      }
    ]);
  }, []);
  return /* @__PURE__ */ React__default.createElement("div", { className: wrapper, "aria-label": ariaLabel }, /* @__PURE__ */ React__default.createElement("div", { className: graphContainer }, /* @__PURE__ */ React__default.createElement(
    Graph,
    {
      series,
      timeRange,
      timeZone,
      showLines,
      showPoints,
      showBars,
      width,
      height,
      isStacked,
      lineWidth,
      onHorizontalRegionSelected
    },
    children
  )), legendVisibility && /* @__PURE__ */ React__default.createElement("div", { className: legendContainer }, /* @__PURE__ */ React__default.createElement(CustomScrollbar, { hideHorizontalTrack: true }, /* @__PURE__ */ React__default.createElement(
    VizLegend,
    {
      items: legendItems,
      displayMode: legendDisplayMode,
      placement,
      sortBy: sortLegendBy,
      sortDesc: sortLegendDesc,
      onLabelClick: (item, event) => {
        if (onSeriesToggle) {
          onSeriesToggle(item.label, event);
        }
      },
      onToggleSort
    }
  ))));
};

export { GraphWithLegend };
//# sourceMappingURL=GraphWithLegend.js.map
