import { css } from '@emotion/css';
import React__default from 'react';
import { useTheme2 } from '../../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../../themes/stylesFactory.js';
import '@emotion/react';
import { getFocusStyles, getMouseFocusStyles } from '../../../themes/mixins.js';
import { getPropertiesForButtonSize } from '../commonStyles.js';

const RadioButton = React__default.forwardRef(
  ({
    children,
    active = false,
    disabled = false,
    size = "md",
    onChange,
    onClick,
    id,
    name = void 0,
    description,
    fullWidth,
    "aria-label": ariaLabel
  }, ref) => {
    const theme = useTheme2();
    const styles = getRadioButtonStyles(theme, size, fullWidth);
    return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, /* @__PURE__ */ React__default.createElement(
      "input",
      {
        type: "radio",
        className: styles.radio,
        onChange,
        onClick,
        disabled,
        id,
        checked: active,
        name,
        "aria-label": ariaLabel,
        ref
      }
    ), /* @__PURE__ */ React__default.createElement("label", { className: styles.radioLabel, htmlFor: id, title: description }, children));
  }
);
RadioButton.displayName = "RadioButton";
const getRadioButtonStyles = stylesFactory((theme, size, fullWidth) => {
  const { fontSize, height, padding } = getPropertiesForButtonSize(size, theme);
  const textColor = theme.colors.text.secondary;
  const textColorHover = theme.colors.text.primary;
  const labelHeight = height * theme.spacing.gridSize - 4 - 2;
  return {
    radio: css`
      position: absolute;
      opacity: 0;
      z-index: -1000;

      &:checked + label {
        color: ${theme.colors.text.primary};
        font-weight: ${theme.typography.fontWeightMedium};
        background: ${theme.colors.action.selected};
        z-index: 3;
      }

      &:focus + label,
      &:focus-visible + label {
        ${getFocusStyles(theme)};
      }

      &:focus:not(:focus-visible) + label {
        ${getMouseFocusStyles()}
      }

      &:disabled + label {
        color: ${theme.colors.text.disabled};
        cursor: not-allowed;
      }
    `,
    radioLabel: css`
      display: inline-block;
      position: relative;
      font-size: ${fontSize};
      height: ${labelHeight}px;
      // Deduct border from line-height for perfect vertical centering on windows and linux
      line-height: ${labelHeight}px;
      color: ${textColor};
      padding: ${theme.spacing(0, padding)};
      border-radius: ${theme.shape.borderRadius()};
      background: ${theme.colors.background.primary};
      cursor: pointer;
      z-index: 1;
      flex: ${fullWidth ? `1 0 0` : "none"};
      text-align: center;
      user-select: none;
      white-space: nowrap;

      &:hover {
        color: ${textColorHover};
      }
    `
  };
});

export { RadioButton };
//# sourceMappingURL=RadioButton.js.map
