import { cx, css } from '@emotion/css';
import React__default, { useCallback } from 'react';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import { getFocusStyles, getMouseFocusStyles } from '../../themes/mixins.js';
import { getLabelStyles } from './Label.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Checkbox = React__default.forwardRef(
  (_a, ref) => {
    var _b = _a, { label, description, value, htmlValue, onChange, disabled, className } = _b, inputProps = __objRest(_b, ["label", "description", "value", "htmlValue", "onChange", "disabled", "className"]);
    const handleOnChange = useCallback(
      (e) => {
        if (onChange) {
          onChange(e);
        }
      },
      [onChange]
    );
    const styles = useStyles2(getCheckboxStyles);
    return /* @__PURE__ */ React__default.createElement("label", { className: cx(styles.wrapper, className) }, /* @__PURE__ */ React__default.createElement("div", { className: styles.checkboxWrapper }, /* @__PURE__ */ React__default.createElement(
      "input",
      __spreadProps(__spreadValues({
        type: "checkbox",
        className: styles.input,
        checked: value,
        disabled,
        onChange: handleOnChange,
        value: htmlValue
      }, inputProps), {
        ref
      })
    ), /* @__PURE__ */ React__default.createElement("span", { className: styles.checkmark })), label && /* @__PURE__ */ React__default.createElement("span", { className: styles.label }, label), description && /* @__PURE__ */ React__default.createElement("span", { className: styles.description }, description));
  }
);
const getCheckboxStyles = stylesFactory((theme) => {
  const labelStyles = getLabelStyles(theme);
  const checkboxSize = 2;
  const labelPadding = 1;
  return {
    wrapper: css`
      display: inline-grid;
      align-items: center;
      column-gap: ${theme.spacing(labelPadding)};
      grid-template-columns: auto 1fr;
      grid-template-rows: auto auto;
      position: relative;
      vertical-align: middle;
    `,
    input: css`
      position: absolute;
      z-index: 1;
      top: 0;
      left: 0;
      width: 100% !important; // global styles unset this
      height: 100%;
      opacity: 0;

      &:focus + span,
      &:focus-visible + span {
        ${getFocusStyles(theme)}
      }

      &:focus:not(:focus-visible) + span {
        ${getMouseFocusStyles()}
      }

      /**
       * Using adjacent sibling selector to style checked state.
       * Primarily to limit the classes necessary to use when these classes will be used
       * for angular components styling
       * */
      &:checked + span {
        background: blue;
        background: ${theme.colors.primary.main};
        border: none;

        &:hover {
          background: ${theme.colors.primary.shade};
        }

        &:after {
          content: '';
          position: absolute;
          z-index: 2;
          left: 5px;
          top: 1px;
          width: 6px;
          height: 12px;
          border: solid ${theme.colors.primary.contrastText};
          border-width: 0 3px 3px 0;
          transform: rotate(45deg);
        }
      }

      &:disabled + span {
        background-color: ${theme.colors.action.disabledBackground};
        cursor: not-allowed;

        &:hover {
          background-color: ${theme.colors.action.disabledBackground};
        }

        &:after {
          border-color: ${theme.colors.action.disabledText};
        }
      }
    `,
    checkboxWrapper: css`
      display: flex;
      align-items: center;
      grid-column-start: 1;
      grid-row-start: 1;
    `,
    checkmark: css`
      position: relative; /* Checkbox should be layered on top of the invisible input so it recieves :hover */
      z-index: 2;
      display: inline-block;
      width: ${theme.spacing(checkboxSize)};
      height: ${theme.spacing(checkboxSize)};
      border-radius: ${theme.shape.borderRadius()};
      background: ${theme.components.input.background};
      border: 1px solid ${theme.components.input.borderColor};

      &:hover {
        cursor: pointer;
        border-color: ${theme.components.input.borderHover};
      }
    `,
    label: cx(
      labelStyles.label,
      css`
        grid-column-start: 2;
        grid-row-start: 1;
        position: relative;
        z-index: 2;
        cursor: pointer;
        max-width: fit-content;
        line-height: ${theme.typography.bodySmall.lineHeight};
        margin-bottom: 0;
      `
    ),
    description: cx(
      labelStyles.description,
      css`
        grid-column-start: 2;
        grid-row-start: 2;
        line-height: ${theme.typography.bodySmall.lineHeight};
        margin-top: 0; /* The margin effectively comes from the top: -2px on the label above it */
      `
    )
  };
});
Checkbox.displayName = "Checkbox";

export { Checkbox, getCheckboxStyles };
//# sourceMappingURL=Checkbox.js.map
