import { cx, css } from '@emotion/css';
import React__default, { useState, useCallback } from 'react';
import { v4 } from 'uuid';
import { selectors } from '@grafana/e2e-selectors';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import { getFocusStyles } from '../../themes/mixins.js';
import { trimFileName } from '../../utils/file.js';
import { getButtonStyles } from '../Button/Button.js';
import '../Button/ButtonGroup.js';
import '../FormField/FormField.js';
import '../Forms/Legacy/Input/Input.js';
import 'react-select';
import { Icon } from '../Icon/Icon.js';
import '../Forms/Legacy/Select/Select.js';
import 'lodash';
import '../Tooltip/Tooltip.js';
import '../SecretFormField/SecretFormField.js';
import '../IconButton/IconButton.js';
import '../ConfirmButton/ConfirmButton.js';
import 'react-popper';
import 'react-transition-group/Transition';
import '../Portal/Portal.js';
import '../Toggletip/Toggletip.js';
import 'react-custom-scrollbars-2';
import 'classnames';
import '../TabbedContainer/TabbedContainer.js';
import '../../utils/i18n.js';
import '../Cascader/Cascader.js';
import '../ButtonCascader/ButtonCascader.js';
import '../Spinner/Spinner.js';
import '../ColorPicker/ColorPicker.js';
import '../ColorPicker/ColorPickerInput.js';
import '../ColorPicker/SeriesColorPickerPopover.js';
import '../StatsPicker/StatsPicker.js';
import '../RefreshPicker/RefreshPicker.js';
import '../DateTimePickers/TimeRangePicker.js';
import 'rc-time-picker';
import 'react-select/async';
import 'react-select/async-creatable';
import 'react-select/creatable';
import '../Select/IndicatorsContainer.js';
import '../Select/InputControl.js';
import '../Select/getSelectStyles.js';
import '../Select/SelectContainer.js';
import '../Select/SelectMenu.js';
import '../Select/SelectOptionGroup.js';
import '../transitions/FadeTransition.js';
import '../transitions/SlideOutTransition.js';
import '../Select/ValueContainer.js';
import '../DateTimePickers/TimeZonePicker/TimeZoneOption.js';
import '../DateTimePickers/DatePicker/DatePicker.js';
import '../Input/Input.js';
import '../DateTimePickers/DateTimePicker/DateTimePicker.js';
import '../List/AbstractList.js';
import 'react-table';
import '../InteractiveTable/ExpanderCell.js';
import '../../utils/dom.js';
import '../../utils/colors.js';
import 'slate';
import 'ansicolor';
import '../../utils/logger.js';
import '../Tags/Tag.js';
import '../Tags/TagList.js';
import '../Modal/Modal.js';
import '../QueryField/QueryField.js';
import '../Monaco/CodeEditor.js';
import 'react-use';
import '../Modal/getModalStyles.js';
import '../Tabs/Tab.js';
import '../Tabs/TabsBar.js';
import '../Modal/ModalsContext.js';
import '../PageLayout/PageToolbar.js';
import 'rxjs';
import 'rxjs/operators';
import '../Table/Table.js';
import '@grafana/schema';
import '../TableInputCSV/TableInputCSV.js';
import '../Tabs/VerticalTab.js';
import '../Tabs/TabContent.js';
import '../Tabs/Counter.js';
import '../BigValue/BigValue.js';
import '../Sparkline/Sparkline.js';
import '../Gauge/Gauge.js';
import '../Graph/Graph.js';
import '../Graph/GraphWithLegend.js';
import '../ContextMenu/ContextMenu.js';
import '../FormattedValueDisplay/FormattedValueDisplay.js';
import '../Menu/MenuGroup.js';
import '../Menu/MenuItem.js';
import '../VizLegend/SeriesIcon.js';
import '../BarGauge/BarGauge.js';
import '../VizTooltip/VizTooltip.js';
import '../VizTooltip/VizTooltipContainer.js';
import '../VizRepeater/VizRepeater.js';
import '../PanelChrome/index.js';
import '../VizLayout/VizLayout.js';
import '../VizLegend/VizLegend.js';
import '../VizLegend/VizLegendListItem.js';
import '../Alert/Alert.js';
import '../Collapse/Collapse.js';
import '../Logs/LogMessageAnsi.js';
import '../Logs/LogRows.js';
import '../Button/FullWidthButtonContainer.js';
import '../ClickOutsideWrapper/ClickOutsideWrapper.js';
import '../Menu/Menu.js';
import '../DataLinks/DataLinksInlineEditor/DataLinksInlineEditor.js';
import '../DataLinks/DataLinkInput.js';
import '../InfoBox/InfoBox.js';
import '../InfoBox/FeatureInfoBox.js';
import '../JSONFormatter/JSONFormatter.js';
import '../ErrorBoundary/ErrorBoundary.js';
import '../ErrorBoundary/ErrorWithStack.js';
import '../Forms/InlineField.js';
import '../Switch/Switch.js';
import '../DataSourceSettings/CustomHeadersSettings.js';
import '../TextArea/TextArea.js';
import 'react-use/lib/useClickAway';
import '@react-aria/dialog';
import '@react-aria/focus';
import '@react-aria/overlays';
import 'rc-drawer';
import '../Slider/Slider.js';
import '../Slider/RangeSlider.js';
import 'react-hook-form';
import '../ToolbarButton/ToolbarButton.js';
import '../ToolbarButton/ToolbarButtonRow.js';
import '../MatchersUI/fieldMatchersUI.js';
import '../Link/Link.js';
import '../Forms/Label.js';
import '../Forms/Field.js';
import '../Forms/FieldSet.js';
import '../Forms/FieldValidationMessage.js';
import '../Forms/InlineSegmentGroup.js';
import '../Badge/Badge.js';
import '../Forms/RadioButtonGroup/RadioButtonGroup.js';
import '../Input/AutoSizeInput.js';
import '../FilterInput/FilterInput.js';
import '../Forms/Checkbox.js';
import 'react-dropzone';
import '../DateTimePickers/TimeRangeInput.js';
import '../DateTimePickers/RelativeTimeRangePicker/RelativeTimeRangePicker.js';
import '../Card/Card.js';
import '../Card/CardContainer.js';
import '../Dropdown/ButtonSelect.js';
import '../Dropdown/Dropdown.js';
import '../PluginSignatureBadge/PluginSignatureBadge.js';
import '../uPlot/config.js';
import 'uplot';
import '../uPlot/utils.js';
import 'tinycolor2';
import '../uPlot/PlotLegend.js';
import '../GraphNG/GraphNG.js';
import '../TimeSeries/TimeSeries.js';
import '../GraphNG/hooks.js';
import '../BrowserLabel/Label.js';

const FileUpload = ({
  onFileUpload,
  className,
  children = "Upload file",
  accept = "*",
  size = "md",
  showFileName
}) => {
  const style = useStyles2(getStyles(size));
  const [fileName, setFileName] = useState("");
  const id = v4();
  const onChange = useCallback(
    (event) => {
      var _a, _b, _c;
      const file = (_b = (_a = event.currentTarget) == null ? void 0 : _a.files) == null ? void 0 : _b[0];
      if (file) {
        setFileName((_c = file.name) != null ? _c : "");
      }
      onFileUpload(event);
    },
    [onFileUpload]
  );
  return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, /* @__PURE__ */ React__default.createElement(
    "input",
    {
      type: "file",
      id,
      className: style.fileUpload,
      onChange,
      multiple: false,
      accept,
      "data-testid": selectors.components.FileUpload.inputField
    }
  ), /* @__PURE__ */ React__default.createElement("label", { htmlFor: id, className: cx(style.labelWrapper, className) }, /* @__PURE__ */ React__default.createElement(Icon, { name: "upload", className: style.icon }), children), showFileName && fileName && /* @__PURE__ */ React__default.createElement(
    "span",
    {
      "aria-label": "File name",
      className: style.fileName,
      "data-testid": selectors.components.FileUpload.fileNameSpan
    },
    trimFileName(fileName)
  ));
};
const getStyles = (size) => (theme) => {
  const buttonStyles = getButtonStyles({ theme, variant: "primary", size, iconOnly: false });
  const focusStyle = getFocusStyles(theme);
  return {
    fileUpload: css({
      height: "0.1px",
      opacity: "0",
      overflow: "hidden",
      position: "absolute",
      width: "0.1px",
      zIndex: -1,
      "&:focus + label": focusStyle,
      "&:focus-visible + label": focusStyle
    }),
    labelWrapper: buttonStyles.button,
    icon: buttonStyles.icon,
    fileName: css({
      marginLeft: theme.spacing(0.5)
    })
  };
};

export { FileUpload };
//# sourceMappingURL=FileUpload.js.map
