import { cx, css } from '@emotion/css';
import { isString } from 'lodash';
import React__default from 'react';
import { dateTimeFormat } from '@grafana/data';
import { useStyles2 } from '../../../themes/ThemeContext.js';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';

const TimeZoneOffset = (props) => {
  const { timestamp, timeZone, className } = props;
  const styles = useStyles2(getStyles);
  if (!isString(timeZone)) {
    return null;
  }
  return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, /* @__PURE__ */ React__default.createElement("span", { className: cx(styles.offset, className) }, formatUtcOffset(timestamp, timeZone)));
};
const formatUtcOffset = (timestamp, timeZone) => {
  const offset = dateTimeFormat(timestamp, {
    timeZone,
    format: "Z"
  });
  if (offset === "+00:00") {
    return "UTC";
  }
  return `UTC${offset}`;
};
const getStyles = (theme) => {
  const textBase = css`
    font-weight: normal;
    font-size: ${theme.typography.size.sm};
    color: ${theme.colors.text.secondary};
    white-space: normal;
  `;
  return {
    offset: css`
      ${textBase};
      color: ${theme.colors.text.primary};
      background: ${theme.colors.background.secondary};
      padding: 2px 5px;
      border-radius: 2px;
      margin-left: 4px;
    `
  };
};

export { TimeZoneOffset, formatUtcOffset };
//# sourceMappingURL=TimeZoneOffset.js.map
