import { css } from '@emotion/css';
import { useDialog } from '@react-aria/dialog';
import { FocusScope } from '@react-aria/focus';
import { useOverlay, OverlayContainer } from '@react-aria/overlays';
import React__default, { memo } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { useTheme2 } from '../../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { getModalStyles } from '../../Modal/getModalStyles.js';
import { Body } from './CalendarBody.js';
import { Footer } from './CalendarFooter.js';
import { Header } from './CalendarHeader.js';

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
const getStyles = (theme, isReversed = false) => {
  return {
    container: css`
      top: 0px;
      position: absolute;
      ${isReversed ? "left" : "right"}: 544px;
      box-shadow: ${theme.shadows.z3};
      background-color: ${theme.colors.background.primary};
      z-index: -1;
      border: 1px solid ${theme.colors.border.weak};
      border-radius: 2px 0 0 2px;

      &:after {
        display: block;
        background-color: ${theme.colors.background.primary};
        width: 19px;
        height: 100%;
        content: ${!isReversed ? " " : ""};
        position: absolute;
        top: 0;
        right: -19px;
        border-left: 1px solid ${theme.colors.border.weak};
      }
    `,
    modal: css`
      box-shadow: ${theme.shadows.z3};
      left: 50%;
      position: fixed;
      top: 50%;
      transform: translate(-50%, -50%);
      z-index: ${theme.zIndex.modal};
    `,
    content: css`
      margin: 0 auto;
      width: 268px;
    `
  };
};
function TimePickerCalendar(props) {
  const theme = useTheme2();
  const { modalBackdrop } = getModalStyles(theme);
  const styles = getStyles(theme, props.isReversed);
  const { isOpen, isFullscreen, onClose } = props;
  const ref = React__default.createRef();
  const { dialogProps } = useDialog(
    {
      "aria-label": selectors.components.TimePicker.calendar.label
    },
    ref
  );
  const { overlayProps } = useOverlay(
    {
      isDismissable: true,
      isOpen,
      onClose
    },
    ref
  );
  if (!isOpen) {
    return null;
  }
  if (isFullscreen) {
    return /* @__PURE__ */ React__default.createElement(FocusScope, { contain: true, restoreFocus: true, autoFocus: true }, /* @__PURE__ */ React__default.createElement("section", __spreadValues(__spreadValues({ className: styles.container, ref }, overlayProps), dialogProps), /* @__PURE__ */ React__default.createElement(Header, __spreadValues({}, props)), /* @__PURE__ */ React__default.createElement(Body, __spreadValues({}, props))));
  }
  return /* @__PURE__ */ React__default.createElement(OverlayContainer, null, /* @__PURE__ */ React__default.createElement("div", { className: modalBackdrop }), /* @__PURE__ */ React__default.createElement(FocusScope, { contain: true, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default.createElement("section", __spreadValues(__spreadValues({ className: styles.modal, ref }, overlayProps), dialogProps), /* @__PURE__ */ React__default.createElement("div", { className: styles.content, "aria-label": selectors.components.TimePicker.calendar.label }, /* @__PURE__ */ React__default.createElement(Header, __spreadValues({}, props)), /* @__PURE__ */ React__default.createElement(Body, __spreadValues({}, props)), /* @__PURE__ */ React__default.createElement(Footer, __spreadValues({}, props))))));
}
var TimePickerCalendar$1 = memo(TimePickerCalendar);
TimePickerCalendar.displayName = "TimePickerCalendar";

export { TimePickerCalendar$1 as default, getStyles };
//# sourceMappingURL=TimePickerCalendar.js.map
