import { css, cx } from '@emotion/css';
import { useDialog } from '@react-aria/dialog';
import { FocusScope } from '@react-aria/focus';
import { useOverlay } from '@react-aria/overlays';
import React__default, { useState, useEffect, useCallback, useRef } from 'react';
import Calendar from 'react-calendar';
import { usePopper } from 'react-popper';
import { useMedia } from 'react-use';
import { dateTimeFormat, dateTime, isDateTime } from '@grafana/data';
import '../../FormField/FormField.js';
import '../../Forms/Legacy/Input/Input.js';
import 'react-select';
import { Icon } from '../../Icon/Icon.js';
import '../../Forms/Legacy/Select/Select.js';
import 'lodash';
import '../../Tooltip/Tooltip.js';
import '../../SecretFormField/SecretFormField.js';
import '../../IconButton/IconButton.js';
import '../../ConfirmButton/ConfirmButton.js';
import { Button } from '../../Button/Button.js';
import '../../Button/ButtonGroup.js';
import 'react-transition-group/Transition';
import { Portal } from '../../Portal/Portal.js';
import '../../Toggletip/Toggletip.js';
import 'react-custom-scrollbars-2';
import { useStyles2, useTheme2 } from '../../../themes/ThemeContext.js';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import 'classnames';
import '../../TabbedContainer/TabbedContainer.js';
import '../../../utils/i18n.js';
import '../../Cascader/Cascader.js';
import '../../ButtonCascader/ButtonCascader.js';
import '../../Spinner/Spinner.js';
import '../../ColorPicker/ColorPicker.js';
import '../../ColorPicker/ColorPickerInput.js';
import '../../ColorPicker/SeriesColorPickerPopover.js';
import '../../StatsPicker/StatsPicker.js';
import '../../RefreshPicker/RefreshPicker.js';
import '../TimeRangePicker.js';
import { TimeOfDayPicker, POPUP_CLASS_NAME } from '../TimeOfDayPicker.js';
import 'react-select/async';
import 'react-select/async-creatable';
import 'react-select/creatable';
import '../../Select/IndicatorsContainer.js';
import '../../Select/InputControl.js';
import '../../Select/getSelectStyles.js';
import '../../Select/SelectContainer.js';
import '../../Select/SelectMenu.js';
import '../../Select/SelectOptionGroup.js';
import '../../transitions/FadeTransition.js';
import '../../transitions/SlideOutTransition.js';
import '../../Select/ValueContainer.js';
import '../TimeZonePicker/TimeZoneOption.js';
import '@grafana/e2e-selectors';
import '../DatePicker/DatePicker.js';
import { Input } from '../../Input/Input.js';
import '../../List/AbstractList.js';
import 'react-table';
import '../../InteractiveTable/ExpanderCell.js';
import '../../../utils/dom.js';
import '../../../utils/colors.js';
import 'slate';
import 'ansicolor';
import '../../../utils/logger.js';
import '../../Tags/Tag.js';
import '../../Tags/TagList.js';
import '../../Modal/Modal.js';
import '../../QueryField/QueryField.js';
import '../../Monaco/CodeEditor.js';
import { getModalStyles } from '../../Modal/getModalStyles.js';
import '../../Tabs/Tab.js';
import '../../Tabs/TabsBar.js';
import '../../Modal/ModalsContext.js';
import '../../PageLayout/PageToolbar.js';
import 'rxjs';
import 'rxjs/operators';
import '../../Table/Table.js';
import '@grafana/schema';
import '../../TableInputCSV/TableInputCSV.js';
import '../../Tabs/VerticalTab.js';
import '../../Tabs/TabContent.js';
import '../../Tabs/Counter.js';
import '../../BigValue/BigValue.js';
import '../../Sparkline/Sparkline.js';
import '../../Gauge/Gauge.js';
import '../../Graph/Graph.js';
import '../../Graph/GraphWithLegend.js';
import '../../ContextMenu/ContextMenu.js';
import '../../FormattedValueDisplay/FormattedValueDisplay.js';
import { HorizontalGroup } from '../../Layout/Layout.js';
import '../../Menu/MenuGroup.js';
import '../../Menu/MenuItem.js';
import '../../VizLegend/SeriesIcon.js';
import '../../BarGauge/BarGauge.js';
import '../../VizTooltip/VizTooltip.js';
import '../../VizTooltip/VizTooltipContainer.js';
import '../../VizRepeater/VizRepeater.js';
import '../../PanelChrome/index.js';
import '../../VizLayout/VizLayout.js';
import '../../VizLegend/VizLegend.js';
import '../../VizLegend/VizLegendListItem.js';
import '../../Alert/Alert.js';
import '../../Collapse/Collapse.js';
import '../../Logs/LogMessageAnsi.js';
import '../../Logs/LogRows.js';
import '../../Button/FullWidthButtonContainer.js';
import '../../ClickOutsideWrapper/ClickOutsideWrapper.js';
import '../../Menu/Menu.js';
import '../../DataLinks/DataLinksInlineEditor/DataLinksInlineEditor.js';
import '../../DataLinks/DataLinkInput.js';
import '../../InfoBox/InfoBox.js';
import '../../InfoBox/FeatureInfoBox.js';
import '../../JSONFormatter/JSONFormatter.js';
import '../../ErrorBoundary/ErrorBoundary.js';
import '../../ErrorBoundary/ErrorWithStack.js';
import { InlineField } from '../../Forms/InlineField.js';
import '../../Switch/Switch.js';
import '../../DataSourceSettings/CustomHeadersSettings.js';
import '../../TextArea/TextArea.js';
import 'react-use/lib/useClickAway';
import 'rc-drawer';
import '../../Slider/Slider.js';
import '../../Slider/RangeSlider.js';
import 'react-hook-form';
import '../../ToolbarButton/ToolbarButton.js';
import '../../ToolbarButton/ToolbarButtonRow.js';
import '../../MatchersUI/fieldMatchersUI.js';
import '../../Link/Link.js';
import '../../Forms/Label.js';
import '../../Forms/Field.js';
import '../../Forms/FieldSet.js';
import '../../Forms/FieldValidationMessage.js';
import '../../Forms/InlineSegmentGroup.js';
import '../../Badge/Badge.js';
import '../../Forms/RadioButtonGroup/RadioButtonGroup.js';
import '../../Input/AutoSizeInput.js';
import '../../FilterInput/FilterInput.js';
import '../../Forms/Checkbox.js';
import 'uuid';
import 'react-dropzone';
import '../TimeRangeInput.js';
import '../RelativeTimeRangePicker/RelativeTimeRangePicker.js';
import '../../Card/Card.js';
import '../../Card/CardContainer.js';
import '../../Dropdown/ButtonSelect.js';
import '../../Dropdown/Dropdown.js';
import '../../PluginSignatureBadge/PluginSignatureBadge.js';
import '../../uPlot/config.js';
import 'uplot';
import '../../uPlot/utils.js';
import '../../uPlot/PlotLegend.js';
import '../../GraphNG/GraphNG.js';
import '../../TimeSeries/TimeSeries.js';
import '../../GraphNG/hooks.js';
import '../../BrowserLabel/Label.js';
import { getBodyStyles } from '../TimeRangePicker/CalendarBody.js';
import { isValid } from '../utils.js';

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
const DateTimePicker = ({
  date,
  maxDate,
  minDate,
  label,
  onChange,
  disabledHours,
  disabledMinutes,
  disabledSeconds,
  showSeconds = true
}) => {
  const [isOpen, setOpen] = useState(false);
  const ref = useRef(null);
  const { overlayProps, underlayProps } = useOverlay(
    {
      onClose: () => setOpen(false),
      isDismissable: true,
      isOpen,
      shouldCloseOnInteractOutside: (element) => {
        const popupElement = document.getElementsByClassName(POPUP_CLASS_NAME)[0];
        return !(popupElement && popupElement.contains(element));
      }
    },
    ref
  );
  const { dialogProps } = useDialog({}, ref);
  const theme = useTheme2();
  const { modalBackdrop } = getModalStyles(theme);
  const isFullscreen = useMedia(`(min-width: ${theme.breakpoints.values.lg}px)`);
  const styles = useStyles2(getStyles);
  const [markerElement, setMarkerElement] = useState();
  const [selectorElement, setSelectorElement] = useState();
  const popper = usePopper(markerElement, selectorElement, {
    placement: "bottom-start"
  });
  const onApply = useCallback(
    (date2) => {
      setOpen(false);
      onChange(date2);
    },
    [onChange]
  );
  const onOpen = useCallback(
    (event) => {
      event.preventDefault();
      setOpen(true);
    },
    [setOpen]
  );
  return /* @__PURE__ */ React__default.createElement("div", { "data-testid": "date-time-picker", style: { position: "relative" } }, /* @__PURE__ */ React__default.createElement(
    DateTimeInput,
    {
      date,
      onChange,
      isFullscreen,
      onOpen,
      label,
      ref: setMarkerElement,
      showSeconds
    }
  ), isOpen ? isFullscreen ? /* @__PURE__ */ React__default.createElement(Portal, null, /* @__PURE__ */ React__default.createElement(FocusScope, { contain: true, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default.createElement("div", __spreadValues(__spreadValues({ ref }, overlayProps), dialogProps), /* @__PURE__ */ React__default.createElement(
    DateTimeCalendar,
    {
      date,
      onChange: onApply,
      isFullscreen: true,
      onClose: () => setOpen(false),
      maxDate,
      minDate,
      ref: setSelectorElement,
      style: popper.styles.popper,
      showSeconds,
      disabledHours,
      disabledMinutes,
      disabledSeconds
    }
  )))) : /* @__PURE__ */ React__default.createElement(Portal, null, /* @__PURE__ */ React__default.createElement("div", __spreadValues({ className: modalBackdrop }, underlayProps)), /* @__PURE__ */ React__default.createElement(FocusScope, { contain: true, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default.createElement("div", __spreadValues(__spreadValues({ ref }, overlayProps), dialogProps), /* @__PURE__ */ React__default.createElement("div", { className: styles.modal }, /* @__PURE__ */ React__default.createElement(
    DateTimeCalendar,
    {
      date,
      maxDate,
      minDate,
      onChange: onApply,
      isFullscreen: false,
      onClose: () => setOpen(false),
      showSeconds,
      disabledHours,
      disabledMinutes,
      disabledSeconds
    }
  ))))) : null);
};
const DateTimeInput = React__default.forwardRef(
  ({ date, label, onChange, isFullscreen, onOpen, showSeconds = true }, ref) => {
    const format = showSeconds ? "YYYY-MM-DD HH:mm:ss" : "YYYY-MM-DD HH:mm";
    const [internalDate, setInternalDate] = useState(() => {
      return { value: date ? dateTimeFormat(date) : dateTimeFormat(dateTime()), invalid: false };
    });
    useEffect(() => {
      if (date) {
        setInternalDate({
          invalid: !isValid(dateTimeFormat(date, { format })),
          value: isDateTime(date) ? dateTimeFormat(date, { format }) : date
        });
      }
    }, [date, format]);
    const onChangeDate = useCallback((event) => {
      const isInvalid = !isValid(event.currentTarget.value);
      setInternalDate({
        value: event.currentTarget.value,
        invalid: isInvalid
      });
    }, []);
    const onBlur = useCallback(() => {
      if (isDateTime(internalDate.value)) {
        onChange(dateTime(internalDate.value));
      }
    }, [internalDate.value, onChange]);
    const icon = /* @__PURE__ */ React__default.createElement(Button, { "aria-label": "Time picker", icon: "calendar-alt", variant: "secondary", onClick: onOpen });
    return /* @__PURE__ */ React__default.createElement(
      InlineField,
      {
        label,
        invalid: !!(internalDate.value && internalDate.invalid),
        className: css`
          margin-bottom: 0;
        `
      },
      /* @__PURE__ */ React__default.createElement(
        Input,
        {
          onChange: onChangeDate,
          addonAfter: icon,
          value: internalDate.value,
          onBlur,
          "data-testid": "date-time-input",
          placeholder: "Select date/time",
          ref
        }
      )
    );
  }
);
DateTimeInput.displayName = "DateTimeInput";
const DateTimeCalendar = React__default.forwardRef(
  ({
    date,
    onClose,
    onChange,
    isFullscreen,
    maxDate,
    minDate,
    style,
    showSeconds = true,
    disabledHours,
    disabledMinutes,
    disabledSeconds
  }, ref) => {
    const calendarStyles = useStyles2(getBodyStyles);
    const styles = useStyles2(getStyles);
    const [internalDate, setInternalDate] = useState(() => {
      if (date && date.isValid()) {
        return date.toDate();
      }
      return new Date();
    });
    const onChangeDate = useCallback((date2) => {
      if (!Array.isArray(date2)) {
        setInternalDate((prevState) => {
          date2.setHours(prevState.getHours());
          date2.setMinutes(prevState.getMinutes());
          date2.setSeconds(prevState.getSeconds());
          return date2;
        });
      }
    }, []);
    const onChangeTime = useCallback((date2) => {
      setInternalDate(date2.toDate());
    }, []);
    return /* @__PURE__ */ React__default.createElement("div", { className: cx(styles.container, { [styles.fullScreen]: isFullscreen }), style, ref }, /* @__PURE__ */ React__default.createElement(
      Calendar,
      {
        next2Label: null,
        prev2Label: null,
        value: internalDate,
        nextLabel: /* @__PURE__ */ React__default.createElement(Icon, { name: "angle-right" }),
        nextAriaLabel: "Next month",
        prevLabel: /* @__PURE__ */ React__default.createElement(Icon, { name: "angle-left" }),
        prevAriaLabel: "Previous month",
        onChange: onChangeDate,
        locale: "en",
        className: calendarStyles.body,
        tileClassName: calendarStyles.title,
        maxDate,
        minDate
      }
    ), /* @__PURE__ */ React__default.createElement("div", { className: styles.time }, /* @__PURE__ */ React__default.createElement(
      TimeOfDayPicker,
      {
        showSeconds,
        onChange: onChangeTime,
        value: dateTime(internalDate),
        disabledHours,
        disabledMinutes,
        disabledSeconds
      }
    )), /* @__PURE__ */ React__default.createElement(HorizontalGroup, null, /* @__PURE__ */ React__default.createElement(Button, { type: "button", onClick: () => onChange(dateTime(internalDate)) }, "Apply"), /* @__PURE__ */ React__default.createElement(Button, { variant: "secondary", type: "button", onClick: onClose }, "Cancel")));
  }
);
DateTimeCalendar.displayName = "DateTimeCalendar";
const getStyles = (theme) => ({
  container: css`
    padding: ${theme.spacing(1)};
    border: 1px ${theme.colors.border.weak} solid;
    border-radius: ${theme.shape.borderRadius(1)};
    background-color: ${theme.colors.background.primary};
    z-index: ${theme.zIndex.modal};
  `,
  fullScreen: css`
    position: absolute;
  `,
  time: css`
    margin-bottom: ${theme.spacing(2)};
  `,
  modal: css`
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    z-index: ${theme.zIndex.modal};
    max-width: 280px;
  `
});

export { DateTimePicker };
//# sourceMappingURL=DateTimePicker.js.map
