import { css } from '@emotion/css';
import React__default, { memo } from 'react';
import Calendar from 'react-calendar';
import { useStyles2 } from '../../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { ClickOutsideWrapper } from '../../ClickOutsideWrapper/ClickOutsideWrapper.js';
import { Icon } from '../../Icon/Icon.js';
import { getBodyStyles } from '../TimeRangePicker/CalendarBody.js';

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
const DatePicker = memo((props) => {
  const styles = useStyles2(getStyles);
  const { isOpen, onClose } = props;
  if (!isOpen) {
    return null;
  }
  return /* @__PURE__ */ React__default.createElement(ClickOutsideWrapper, { useCapture: true, includeButtonPress: false, onClick: onClose }, /* @__PURE__ */ React__default.createElement("div", { className: styles.modal, "data-testid": "date-picker" }, /* @__PURE__ */ React__default.createElement(Body, __spreadValues({}, props))));
});
DatePicker.displayName = "DatePicker";
const Body = memo(({ value, minDate, maxDate, onChange }) => {
  const styles = useStyles2(getBodyStyles);
  return /* @__PURE__ */ React__default.createElement(
    Calendar,
    {
      className: styles.body,
      tileClassName: styles.title,
      value: value || new Date(),
      minDate,
      maxDate,
      nextLabel: /* @__PURE__ */ React__default.createElement(Icon, { name: "angle-right" }),
      prevLabel: /* @__PURE__ */ React__default.createElement(Icon, { name: "angle-left" }),
      onChange: (ev) => {
        if (!Array.isArray(ev)) {
          onChange(ev);
        }
      },
      locale: "en"
    }
  );
});
Body.displayName = "Body";
const getStyles = (theme) => {
  return {
    modal: css`
      z-index: ${theme.zIndex.modal};
      position: absolute;
      box-shadow: ${theme.shadows.z3};
      background-color: ${theme.colors.background.primary};
      border: 1px solid ${theme.colors.border.weak};
      border-radius: 2px 0 0 2px;

      button:disabled {
        color: ${theme.colors.text.disabled};
      }
    `
  };
};

export { DatePicker, getStyles };
//# sourceMappingURL=DatePicker.js.map
