import { css, cx } from '@emotion/css';
import React__default, { PureComponent } from 'react';
import { withTheme2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';
import { Button } from '../Button/Button.js';
import '../Button/ButtonGroup.js';

class UnThemedConfirmButton extends PureComponent {
  constructor() {
    super(...arguments);
    this.mainButtonRef = React__default.createRef();
    this.confirmButtonRef = React__default.createRef();
    this.state = {
      showConfirm: false
    };
    this.onClickButton = (event) => {
      if (event) {
        event.preventDefault();
      }
      this.setState(
        {
          showConfirm: true
        },
        () => {
          if (this.props.autoFocus && this.confirmButtonRef.current) {
            this.confirmButtonRef.current.focus();
          }
        }
      );
      if (this.props.onClick) {
        this.props.onClick();
      }
    };
    this.onClickCancel = (event) => {
      if (event) {
        event.preventDefault();
      }
      this.setState(
        {
          showConfirm: false
        },
        () => {
          var _a;
          (_a = this.mainButtonRef.current) == null ? void 0 : _a.focus();
        }
      );
      if (this.props.onCancel) {
        this.props.onCancel();
      }
    };
    this.onConfirm = (event) => {
      if (event) {
        event.preventDefault();
      }
      this.props.onConfirm();
      if (this.props.closeOnConfirm) {
        this.setState({
          showConfirm: false
        });
      }
    };
  }
  render() {
    const {
      theme,
      className,
      size,
      disabled,
      confirmText,
      confirmVariant: confirmButtonVariant,
      children
    } = this.props;
    const styles = getStyles(theme);
    const buttonClass = cx(
      className,
      this.state.showConfirm ? styles.buttonHide : styles.buttonShow,
      disabled && styles.buttonDisabled
    );
    const confirmButtonClass = cx(
      styles.confirmButton,
      this.state.showConfirm ? styles.confirmButtonShow : styles.confirmButtonHide
    );
    const onClick = disabled ? () => {
    } : this.onClickButton;
    return /* @__PURE__ */ React__default.createElement("span", { className: styles.buttonContainer }, /* @__PURE__ */ React__default.createElement("div", { className: cx(disabled && styles.disabled) }, typeof children === "string" ? /* @__PURE__ */ React__default.createElement("span", { className: buttonClass }, /* @__PURE__ */ React__default.createElement(Button, { size, fill: "text", onClick, ref: this.mainButtonRef }, children)) : /* @__PURE__ */ React__default.createElement("span", { className: buttonClass, onClick }, children)), /* @__PURE__ */ React__default.createElement("span", { className: confirmButtonClass }, /* @__PURE__ */ React__default.createElement(Button, { size, variant: confirmButtonVariant, onClick: this.onConfirm, ref: this.confirmButtonRef }, confirmText), /* @__PURE__ */ React__default.createElement(Button, { size, fill: "text", onClick: this.onClickCancel }, "Cancel")));
  }
}
const ConfirmButton = withTheme2(UnThemedConfirmButton);
const getStyles = stylesFactory((theme) => {
  return {
    buttonContainer: css`
      display: flex;
      align-items: center;
      justify-content: flex-end;
    `,
    buttonDisabled: css`
      text-decoration: none;
      color: ${theme.colors.text.primary};
      opacity: 0.65;
      pointer-events: none;
    `,
    buttonShow: css`
      opacity: 1;
      transition: opacity 0.1s ease;
      z-index: 2;
    `,
    buttonHide: css`
      opacity: 0;
      transition: opacity 0.1s ease, visibility 0 0.1s;
      visibility: hidden;
      z-index: 0;
    `,
    confirmButton: css`
      align-items: flex-start;
      background: ${theme.colors.background.primary};
      display: flex;
      position: absolute;
      pointer-events: none;
    `,
    confirmButtonShow: css`
      z-index: 1;
      opacity: 1;
      transition: opacity 0.08s ease-out, transform 0.1s ease-out;
      transform: translateX(0);
      pointer-events: all;
    `,
    confirmButtonHide: css`
      opacity: 0;
      visibility: hidden;
      transition: opacity 0.12s ease-in, transform 0.14s ease-in, visibility 0s 0.12s;
      transform: translateX(100px);
    `,
    disabled: css`
      cursor: not-allowed;
    `
  };
});
ConfirmButton.defaultProps = {
  size: "md",
  confirmText: "Save",
  disabled: false,
  confirmVariant: "primary"
};
ConfirmButton.displayName = "ConfirmButton";

export { ConfirmButton };
//# sourceMappingURL=ConfirmButton.js.map
