let singleton;
function setPluginExtensionGetter(instance) {
  if (singleton && process.env.NODE_ENV !== "test") {
    throw new Error("setPluginExtensionGetter() function should only be called once, when Grafana is starting.");
  }
  singleton = instance;
}
function getPluginExtensionGetter() {
  if (!singleton) {
    throw new Error("getPluginExtensionGetter() can only be used after the Grafana instance has started.");
  }
  return singleton;
}
const getPluginExtensions = (options) => getPluginExtensionGetter()(options);

export { getPluginExtensions, setPluginExtensionGetter };
//# sourceMappingURL=getPluginExtensions.js.map
