var EchoEventType = /* @__PURE__ */ ((EchoEventType2) => {
  EchoEventType2["Performance"] = "performance";
  EchoEventType2["MetaAnalytics"] = "meta-analytics";
  EchoEventType2["Sentry"] = "sentry";
  EchoEventType2["Pageview"] = "pageview";
  EchoEventType2["Interaction"] = "interaction";
  EchoEventType2["ExperimentView"] = "experimentview";
  EchoEventType2["GrafanaJavascriptAgent"] = "grafana-javascript-agent";
  return EchoEventType2;
})(EchoEventType || {});
let singletonInstance;
function setEchoSrv(instance) {
  singletonInstance = instance;
}
function getEchoSrv() {
  if (!singletonInstance) {
    singletonInstance = new FakeEchoSrv();
  }
  return singletonInstance;
}
const registerEchoBackend = (backend) => {
  getEchoSrv().addBackend(backend);
};
class FakeEchoSrv {
  constructor() {
    this.events = [];
  }
  flush() {
    this.events = [];
  }
  addBackend(backend) {
  }
  addEvent(event, meta) {
    this.events.push(event);
  }
}

export { EchoEventType, FakeEchoSrv, getEchoSrv, registerEchoBackend, setEchoSrv };
//# sourceMappingURL=EchoSrv.js.map
