import { merge } from 'lodash';
import { systemDateFormats, createTheme } from '@grafana/data';

class GrafanaBootConfig {
  constructor(options2) {
    this.snapshotEnabled = true;
    this.datasources = {};
    this.panels = {};
    this.apps = {};
    this.auth = {};
    this.minRefreshInterval = "";
    this.appUrl = "";
    this.appSubUrl = "";
    this.windowTitlePrefix = "";
    this.newPanelTitle = "";
    this.externalUserMngLinkUrl = "";
    this.externalUserMngLinkName = "";
    this.externalUserMngInfo = "";
    this.allowOrgCreate = false;
    this.feedbackLinksEnabled = true;
    this.disableLoginForm = false;
    this.defaultDatasource = "";
    // UID
    this.alertingEnabled = false;
    this.alertingErrorOrTimeout = "";
    this.alertingNoDataOrNullValues = "";
    this.alertingMinInterval = 1;
    this.angularSupportEnabled = false;
    this.authProxyEnabled = false;
    this.exploreEnabled = false;
    this.queryHistoryEnabled = false;
    this.helpEnabled = false;
    this.profileEnabled = false;
    this.ldapEnabled = false;
    this.jwtHeaderName = "";
    this.jwtUrlLogin = false;
    this.sigV4AuthEnabled = false;
    this.azureAuthEnabled = false;
    this.samlEnabled = false;
    this.samlName = "";
    this.autoAssignOrg = true;
    this.verifyEmailEnabled = false;
    this.oauth = {};
    this.rbacEnabled = true;
    this.disableUserSignUp = false;
    this.loginHint = "";
    this.passwordHint = "";
    this.loginError = void 0;
    this.viewersCanEdit = false;
    this.editorsCanAdmin = false;
    this.disableSanitizeHtml = false;
    this.liveEnabled = true;
    this.featureToggles = {};
    this.anonymousEnabled = false;
    this.licenseInfo = {};
    this.rendererAvailable = false;
    this.dashboardPreviews = { systemRequirements: { met: false, requiredImageRendererPluginVersion: "" }, thumbnailsExist: false };
    this.rendererVersion = "";
    this.secretsManagerPluginEnabled = false;
    this.supportBundlesEnabled = false;
    this.http2Enabled = false;
    this.sentry = {
      enabled: false,
      dsn: "",
      customEndpoint: "",
      sampleRate: 1
    };
    this.grafanaJavascriptAgent = {
      enabled: false,
      customEndpoint: "",
      apiKey: "",
      errorInstrumentalizationEnabled: true,
      consoleInstrumentalizationEnabled: false,
      webVitalsInstrumentalizationEnabled: false
    };
    this.pluginCatalogURL = "https://grafana.com/grafana/plugins/";
    this.pluginAdminEnabled = true;
    this.pluginAdminExternalManageEnabled = false;
    this.pluginCatalogHiddenPlugins = [];
    this.pluginsCDNBaseURL = "";
    this.expressionsEnabled = false;
    this.awsAllowedAuthProviders = [];
    this.awsAssumeRoleEnabled = false;
    this.azure = {
      managedIdentityEnabled: false,
      workloadIdentityEnabled: false
    };
    this.caching = {
      enabled: false
    };
    this.unifiedAlertingEnabled = false;
    this.unifiedAlerting = { minInterval: "" };
    this.recordedQueries = {
      enabled: true
    };
    this.featureHighlights = {
      enabled: false
    };
    this.reporting = {
      enabled: true
    };
    this.googleAnalytics4SendManualPageViews = false;
    this.sqlConnectionLimits = {
      maxOpenConns: 100,
      maxIdleConns: 100,
      connMaxLifetime: 14400
    };
    this.bootData = options2.bootData;
    this.bootData.user.lightTheme = getThemeMode(options2) === "light";
    this.isPublicDashboardView = options2.bootData.settings.isPublicDashboardView;
    const defaults = {
      datasources: {},
      windowTitlePrefix: "Grafana - ",
      panels: {},
      newPanelTitle: "Panel Title",
      playlist_timespan: "1m",
      unsaved_changes_warning: true,
      appUrl: "",
      appSubUrl: "",
      buildInfo: {
        version: "1.0",
        commit: "1",
        env: "production"
      },
      viewersCanEdit: false,
      editorsCanAdmin: false,
      disableSanitizeHtml: false
    };
    merge(this, defaults, options2);
    this.buildInfo = options2.buildInfo || defaults.buildInfo;
    if (this.dateFormats) {
      systemDateFormats.update(this.dateFormats);
    }
    overrideFeatureTogglesFromUrl(this);
    if (this.featureToggles.disableAngular) {
      this.angularSupportEnabled = false;
    }
    this.theme2 = createTheme(getThemeCustomizations(this));
    this.theme = this.theme2.v1;
    this.theme2.flags.topnav = this.featureToggles.topnav;
  }
}
function getThemeMode(config2) {
  let mode = "dark";
  const themePref = config2.bootData.user.theme;
  if (themePref === "light" || themePref === "dark") {
    mode = themePref;
  } else if (themePref === "system") {
    const mediaResult = window.matchMedia("(prefers-color-scheme: dark)");
    mode = mediaResult.matches ? "dark" : "light";
  }
  return mode;
}
function getThemeCustomizations(config2) {
  const mode = config2.bootData.user.lightTheme ? "light" : "dark";
  const themeOptions = {
    colors: { mode }
  };
  return themeOptions;
}
function overrideFeatureTogglesFromUrl(config2) {
  if (window.location.href.indexOf("__feature") === -1) {
    return;
  }
  const params = new URLSearchParams(window.location.search);
  params.forEach((value, key) => {
    if (key.startsWith("__feature.")) {
      const featureToggles = config2.featureToggles;
      const featureName = key.substring(10);
      const toggleState = value === "true";
      if (toggleState !== featureToggles[key]) {
        featureToggles[featureName] = toggleState;
        console.log(`Setting feature toggle ${featureName} = ${toggleState}`);
      }
    }
  });
}
const bootData = window.grafanaBootData || {
  settings: {},
  user: {},
  navTree: []
};
const options = bootData.settings;
options.bootData = bootData;
const config = new GrafanaBootConfig(options);

export { GrafanaBootConfig, config };
//# sourceMappingURL=config.js.map
