"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toolkitBuildTask = void 0;
const tslib_1 = require("tslib");
const chalk_1 = tslib_1.__importDefault(require("chalk"));
const execa = require("execa");
const fs = tslib_1.__importStar(require("fs"));
const useSpinner_1 = require("../utils/useSpinner");
const task_1 = require("./task");
const path = require('path');
let distDir, cwd;
const clean = () => (0, useSpinner_1.useSpinner)('Cleaning', () => execa('npm', ['run', 'clean']));
const compile = () => (0, useSpinner_1.useSpinner)('Compiling sources', () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    try {
        yield execa('tsc', ['-p', './tsconfig.json']);
    }
    catch (e) {
        console.log(e);
        throw e;
    }
}));
const copyFiles = () => {
    const files = [
        'src/config/prettier.plugin.config.json',
        'src/config/prettier.plugin.rc.js',
        'src/config/tsconfig.plugin.json',
        'src/config/tsconfig.plugin.local.json',
        'src/config/eslint.plugin.js',
        'src/config/styles.mock.js',
        'src/config/jest.babel.config.js',
        'src/config/jest.plugin.config.local.js',
        'src/config/matchMedia.js',
        'src/config/react-inlinesvg.tsx',
    ];
    return (0, useSpinner_1.useSpinner)(`Moving ${files.join(', ')} files`, () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        const promises = files.map((file) => {
            return new Promise((resolve, reject) => {
                const basedir = path.dirname(`${distDir}/${file}`);
                if (!fs.existsSync(basedir)) {
                    fs.mkdirSync(basedir, { recursive: true });
                }
                fs.copyFile(`${cwd}/${file}`, `${distDir}/${file}`, (err) => {
                    if (err) {
                        reject(err);
                        return;
                    }
                    resolve();
                });
            });
        });
        yield Promise.all(promises);
    }));
};
const copySassFiles = () => {
    const files = ['_variables.generated.scss', '_variables.dark.generated.scss', '_variables.light.generated.scss'];
    const exportDir = `${cwd}/sass`;
    return (0, useSpinner_1.useSpinner)(`Copy scss files ${files.join(', ')} files`, () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        const sassDir = path.resolve(cwd, '../../public/sass/');
        if (!fs.existsSync(exportDir)) {
            fs.mkdirSync(exportDir);
        }
        const promises = files.map((file) => {
            return new Promise((resolve, reject) => {
                const name = file.replace('.generated', '');
                fs.copyFile(`${sassDir}/${file}`, `${exportDir}/${name}`, (err) => {
                    if (err) {
                        reject(err);
                        return;
                    }
                    resolve();
                });
            });
        });
        yield Promise.all(promises);
    }));
};
const toolkitBuildTaskRunner = () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    cwd = path.resolve(__dirname, '../../../');
    distDir = `${cwd}/dist`;
    const pkg = require(`${cwd}/package.json`);
    console.log(chalk_1.default.yellow(`Building ${pkg.name} (package.json version: ${pkg.version})`));
    yield clean();
    yield compile();
    yield copyFiles();
    yield copySassFiles();
});
exports.toolkitBuildTask = new task_1.Task('@grafana/toolkit build', toolkitBuildTaskRunner);
//# sourceMappingURL=toolkit.build.js.map