import { vectorToArray } from './vectorToArray.js';

class SortedVector {
  constructor(source, order) {
    this.source = source;
    this.order = order;
  }
  get length() {
    return this.source.length;
  }
  get(index) {
    return this.source.get(this.order[index]);
  }
  toArray() {
    return vectorToArray(this);
  }
  toJSON() {
    return vectorToArray(this);
  }
  getOrderArray() {
    return this.order;
  }
}

export { SortedVector };
//# sourceMappingURL=SortedVector.js.map
