import { vectorToArray } from './vectorToArray.js';

class FunctionalVector {
  // Implement "iterator protocol"
  *iterator() {
    for (let i = 0; i < this.length; i++) {
      yield this.get(i);
    }
  }
  // Implement "iterable protocol"
  [Symbol.iterator]() {
    return this.iterator();
  }
  forEach(iterator) {
    return vectorator(this).forEach(iterator);
  }
  map(transform) {
    return vectorator(this).map(transform);
  }
  filter(predicate) {
    return vectorator(this).filter(predicate);
  }
  toArray() {
    return vectorToArray(this);
  }
  toJSON() {
    return this.toArray();
  }
}
function vectorator(vector) {
  return {
    *[Symbol.iterator]() {
      for (let i = 0; i < vector.length; i++) {
        yield vector.get(i);
      }
    },
    forEach(iterator) {
      for (let i = 0; i < vector.length; i++) {
        iterator(vector.get(i));
      }
    },
    map(transform) {
      const result = [];
      for (let i = 0; i < vector.length; i++) {
        result.push(transform(vector.get(i), i));
      }
      return result;
    },
    /** Add a predicate where you return true if it should *keep* the value */
    filter(predicate) {
      const result = [];
      for (const val of this) {
        if (predicate(val)) {
          result.push(val);
        }
      }
      return result;
    }
  };
}

export { FunctionalVector, vectorator };
//# sourceMappingURL=FunctionalVector.js.map
