import { vectorToArray } from './vectorToArray.js';

class AppendedVectors {
  constructor(startAt = 0) {
    this.length = 0;
    this.source = [];
    this.length = startAt;
  }
  /**
   * Make the vector look like it is this long
   */
  setLength(length) {
    if (length > this.length) {
      this.length = length;
    } else if (length < this.length) {
      const sources = [];
      for (const src of this.source) {
        sources.push(src);
        if (src.end > length) {
          src.end = length;
          break;
        }
      }
      this.source = sources;
      this.length = length;
    }
  }
  append(v) {
    const info = {
      start: this.length,
      end: this.length + v.length,
      values: v
    };
    this.length = info.end;
    this.source.push(info);
    return info;
  }
  get(index) {
    for (let i = 0; i < this.source.length; i++) {
      const src = this.source[i];
      if (index >= src.start && index < src.end) {
        return src.values.get(index - src.start);
      }
    }
    return void 0;
  }
  toArray() {
    return vectorToArray(this);
  }
  toJSON() {
    return vectorToArray(this);
  }
}

export { AppendedVectors };
//# sourceMappingURL=AppendedVectors.js.map
