import { Registry } from './Registry.js';

var BinaryOperationID = /* @__PURE__ */ ((BinaryOperationID2) => {
  BinaryOperationID2["Add"] = "+";
  BinaryOperationID2["Subtract"] = "-";
  BinaryOperationID2["Divide"] = "/";
  BinaryOperationID2["Multiply"] = "*";
  return BinaryOperationID2;
})(BinaryOperationID || {});
const binaryOperators = new Registry(() => {
  return [
    {
      id: "+" /* Add */,
      name: "Add",
      operation: (a, b) => a + b
    },
    {
      id: "-" /* Subtract */,
      name: "Subtract",
      operation: (a, b) => a - b
    },
    {
      id: "*" /* Multiply */,
      name: "Multiply",
      operation: (a, b) => a * b
    },
    {
      id: "/" /* Divide */,
      name: "Divide",
      operation: (a, b) => a / b
    }
  ];
});

export { BinaryOperationID, binaryOperators };
//# sourceMappingURL=binaryOperators.js.map
