import { filterFieldsByNameTransformer } from './filterByName.js';
import { DataTransformerID } from './ids.js';
import { orderFieldsTransformer } from './order.js';
import { renameFieldsTransformer } from './rename.js';

const organizeFieldsTransformer = {
  id: DataTransformerID.organize,
  name: "Organize fields by name",
  description: "Order, filter and rename fields based on configuration given by user",
  defaultOptions: {
    excludeByName: {},
    indexByName: {},
    renameByName: {}
  },
  /**
   * Return a modified copy of the series.  If the transform is not or should not
   * be applied, just return the input series
   */
  operator: (options, ctx) => (source) => source.pipe(
    filterFieldsByNameTransformer.operator(
      {
        exclude: { names: mapToExcludeArray(options.excludeByName) }
      },
      ctx
    ),
    orderFieldsTransformer.operator(options, ctx),
    renameFieldsTransformer.operator(options, ctx)
  )
};
const mapToExcludeArray = (excludeByName) => {
  if (!excludeByName) {
    return [];
  }
  return Object.keys(excludeByName).filter((name) => excludeByName[name]);
};

export { organizeFieldsTransformer };
//# sourceMappingURL=organize.js.map
