import { captureMessage, Severity, captureException } from '@sentry/browser';
export { Severity as LogLevel } from '@sentry/browser';
import { faro, LogLevel } from '@grafana/faro-web-sdk';
import { config } from '../config.js';

function logInfo(message, contexts) {
  if (config.grafanaJavascriptAgent.enabled) {
    faro.api.pushLog([message], {
      level: LogLevel.INFO,
      context: contexts
    });
  }
  if (config.sentry.enabled) {
    captureMessage(message, {
      level: Severity.Info,
      contexts
    });
  }
}
function logWarning(message, contexts) {
  if (config.grafanaJavascriptAgent.enabled) {
    faro.api.pushLog([message], {
      level: LogLevel.WARN,
      context: contexts
    });
  }
  if (config.sentry.enabled) {
    captureMessage(message, {
      level: Severity.Warning,
      contexts
    });
  }
}
function logDebug(message, contexts) {
  if (config.grafanaJavascriptAgent.enabled) {
    faro.api.pushLog([message], {
      level: LogLevel.DEBUG,
      context: contexts
    });
  }
  if (config.sentry.enabled) {
    captureMessage(message, {
      level: Severity.Debug,
      contexts
    });
  }
}
function logError(err, contexts) {
  if (config.grafanaJavascriptAgent.enabled) {
    faro.api.pushError(err);
  }
  if (config.sentry.enabled) {
    captureException(err, { contexts });
  }
}

export { logDebug, logError, logInfo, logWarning };
//# sourceMappingURL=logging.js.map
