import { css } from '@emotion/css';
import React__default from 'react';
import { CSSTransition } from 'react-transition-group';
import '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';

const getStyles = stylesFactory((duration) => {
  return {
    enter: css`
      label: enter;
      opacity: 0;
    `,
    enterActive: css`
      label: enterActive;
      opacity: 1;
      transition: opacity ${duration}ms ease-out;
    `,
    exit: css`
      label: exit;
      opacity: 1;
    `,
    exitActive: css`
      label: exitActive;
      opacity: 0;
      transition: opacity ${duration}ms ease-out;
    `
  };
});
function FadeTransition(props) {
  const { visible, children, duration = 250 } = props;
  const styles = getStyles(duration);
  return /* @__PURE__ */ React__default.createElement(CSSTransition, { in: visible, mountOnEnter: true, unmountOnExit: true, timeout: duration, classNames: styles }, children);
}

export { FadeTransition };
//# sourceMappingURL=FadeTransition.js.map
