import { cx, css } from '@emotion/css';
import { orderBy } from 'lodash';
import React__default from 'react';
import { useStyles2 } from '../../themes/ThemeContext.js';
import { Icon } from '../Icon/Icon.js';
import { LegendTableItem } from './VizLegendTableItem.js';

const VizLegendTable = ({
  items,
  sortBy: sortKey,
  sortDesc,
  itemRenderer,
  className,
  onToggleSort,
  onLabelClick,
  onLabelMouseOver,
  onLabelMouseOut,
  readonly
}) => {
  var _a;
  const styles = useStyles2(getStyles);
  const stats = {};
  for (const item of items) {
    if (item.getDisplayValues) {
      for (const displayValue of item.getDisplayValues()) {
        stats[(_a = displayValue.title) != null ? _a : "?"] = displayValue;
      }
    }
  }
  const sortedItems = sortKey ? orderBy(
    items,
    (item) => {
      if (item.getDisplayValues) {
        const stat = item.getDisplayValues().filter((stat2) => stat2.title === sortKey)[0];
        return stat && stat.numeric;
      }
      return void 0;
    },
    sortDesc ? "desc" : "asc"
  ) : items;
  if (!itemRenderer) {
    itemRenderer = (item, index) => /* @__PURE__ */ React__default.createElement(
      LegendTableItem,
      {
        key: `${item.label}-${index}`,
        item,
        onLabelClick,
        onLabelMouseOver,
        onLabelMouseOut,
        readonly
      }
    );
  }
  return /* @__PURE__ */ React__default.createElement("table", { className: cx(styles.table, className) }, /* @__PURE__ */ React__default.createElement("thead", null, /* @__PURE__ */ React__default.createElement("tr", null, /* @__PURE__ */ React__default.createElement("th", null), Object.keys(stats).map((columnTitle) => {
    const displayValue = stats[columnTitle];
    return /* @__PURE__ */ React__default.createElement(
      "th",
      {
        title: displayValue.description,
        key: columnTitle,
        className: cx(styles.header, onToggleSort && styles.headerSortable, {
          [styles.withIcon]: sortKey === columnTitle
        }),
        onClick: () => {
          if (onToggleSort) {
            onToggleSort(columnTitle);
          }
        }
      },
      columnTitle,
      sortKey === columnTitle && /* @__PURE__ */ React__default.createElement(Icon, { size: "xs", name: sortDesc ? "angle-down" : "angle-up" })
    );
  }))), /* @__PURE__ */ React__default.createElement("tbody", null, sortedItems.map(itemRenderer)));
};
const getStyles = (theme) => ({
  table: css`
    width: 100%;
    th:first-child {
      width: 100%;
      border-bottom: 1px solid ${theme.colors.border.weak};
    }
  `,
  header: css`
    color: ${theme.colors.primary.text};
    font-weight: ${theme.typography.fontWeightMedium};
    border-bottom: 1px solid ${theme.colors.border.weak};
    padding: ${theme.spacing(0.25, 1, 0.25, 1)};
    font-size: ${theme.typography.bodySmall.fontSize};
    text-align: right;
    white-space: nowrap;
  `,
  // This needs to be padding-right - icon size(xs==12) to avoid jumping
  withIcon: css`
    padding-right: 4px;
  `,
  headerSortable: css`
    cursor: pointer;
  `
});

export { VizLegendTable };
//# sourceMappingURL=VizLegendTable.js.map
