import { isArray } from 'lodash';
import React__default from 'react';
import { getMinMaxAndDelta, FieldType, ArrayVector, isDataFrame } from '@grafana/data';
import { GraphDrawStyle, LineInterpolation, GraphGradientMode, BarAlignment, VisibilityMode, TableCellDisplayMode } from '@grafana/schema';
import { Sparkline } from '../Sparkline/Sparkline.js';
import { getCellOptions } from './utils.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const defaultSparklineCellConfig = {
  drawStyle: GraphDrawStyle.Line,
  lineInterpolation: LineInterpolation.Smooth,
  lineWidth: 1,
  fillOpacity: 17,
  gradientMode: GraphGradientMode.Hue,
  pointSize: 2,
  barAlignment: BarAlignment.Center,
  showPoints: VisibilityMode.Never
};
const SparklineCell = (props) => {
  const { field, innerWidth, tableStyles, cell, cellProps } = props;
  const sparkline = getSparkline(cell.value);
  if (!sparkline) {
    return /* @__PURE__ */ React__default.createElement("div", __spreadProps(__spreadValues({}, cellProps), { className: tableStyles.cellContainer }), "no data");
  }
  const range = getMinMaxAndDelta(sparkline.y);
  sparkline.y.config.min = range.min;
  sparkline.y.config.max = range.max;
  sparkline.y.state = { range };
  const cellOptions = getTableSparklineCellOptions(field);
  const config = {
    color: field.config.color,
    custom: __spreadValues(__spreadValues({}, defaultSparklineCellConfig), cellOptions)
  };
  return /* @__PURE__ */ React__default.createElement("div", __spreadProps(__spreadValues({}, cellProps), { className: tableStyles.cellContainer }), /* @__PURE__ */ React__default.createElement(
    Sparkline,
    {
      width: innerWidth,
      height: tableStyles.cellHeightInner,
      sparkline,
      config,
      theme: tableStyles.theme
    }
  ));
};
function getSparkline(value) {
  if (isArray(value)) {
    return {
      y: {
        name: "test",
        type: FieldType.number,
        values: new ArrayVector(value),
        config: {}
      }
    };
  }
  if (isDataFrame(value)) {
    const timeField = value.fields.find((x) => x.type === FieldType.time);
    const numberField = value.fields.find((x) => x.type === FieldType.number);
    if (timeField && numberField) {
      return { x: timeField, y: numberField };
    }
  }
  return;
}
function getTableSparklineCellOptions(field) {
  let options = getCellOptions(field);
  if (options.type === TableCellDisplayMode.Auto) {
    options = __spreadProps(__spreadValues({}, options), { type: TableCellDisplayMode.Sparkline });
  }
  if (options.type === TableCellDisplayMode.Sparkline) {
    return options;
  }
  throw new Error(`Excpected options type ${TableCellDisplayMode.Sparkline} but got ${options.type}`);
}

export { SparklineCell, defaultSparklineCellConfig };
//# sourceMappingURL=SparklineCell.js.map
