import { cx, css } from '@emotion/css';
import React__default from 'react';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { commonColorsPalette } from '../../themes/default.js';
import { Icon } from '../Icon/Icon.js';
import { Tooltip } from '../Tooltip/Tooltip.js';

const ErrorIndicator = ({ error, onClick }) => {
  const styles = useStyles2(getStyles);
  if (!error) {
    return null;
  }
  return /* @__PURE__ */ React__default.createElement(Tooltip, { theme: "error", content: error }, /* @__PURE__ */ React__default.createElement(
    Icon,
    {
      onClick,
      className: cx(styles.icon, { [styles.clickable]: !!onClick }),
      size: "sm",
      name: "exclamation-triangle"
    }
  ));
};
const getStyles = () => {
  return {
    clickable: css({
      cursor: "pointer"
    }),
    icon: css({
      color: `${commonColorsPalette.red88}`
    })
  };
};

export { ErrorIndicator };
//# sourceMappingURL=ErrorIndicator.js.map
