import { cx, css } from '@emotion/css';
import React__default from 'react';
import { selectors } from '@grafana/e2e-selectors';
import '../FormField/FormField.js';
import '../Forms/Legacy/Input/Input.js';
import 'react-select';
import { Icon } from '../Icon/Icon.js';
import '../Forms/Legacy/Select/Select.js';
import 'lodash';
import '../Tooltip/Tooltip.js';
import '../SecretFormField/SecretFormField.js';
import { IconButton } from '../IconButton/IconButton.js';
import '../ConfirmButton/ConfirmButton.js';
import '../Button/Button.js';
import '../Button/ButtonGroup.js';
import 'react-popper';
import 'react-transition-group/Transition';
import '../Portal/Portal.js';
import '../Toggletip/Toggletip.js';
import 'react-custom-scrollbars-2';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import { getFocusStyles } from '../../themes/mixins.js';
import 'classnames';
import '../TabbedContainer/TabbedContainer.js';
import '../../utils/i18n.js';
import '../Cascader/Cascader.js';
import '../ButtonCascader/ButtonCascader.js';
import '../Spinner/Spinner.js';
import '../ColorPicker/ColorPicker.js';
import '../ColorPicker/ColorPickerInput.js';
import '../ColorPicker/SeriesColorPickerPopover.js';
import '../StatsPicker/StatsPicker.js';
import '../RefreshPicker/RefreshPicker.js';
import '../DateTimePickers/TimeRangePicker.js';
import 'rc-time-picker';
import 'react-select/async';
import 'react-select/async-creatable';
import 'react-select/creatable';
import '../Select/IndicatorsContainer.js';
import '../Select/InputControl.js';
import '../Select/getSelectStyles.js';
import '../Select/SelectContainer.js';
import '../Select/SelectMenu.js';
import '../Select/SelectOptionGroup.js';
import '../transitions/FadeTransition.js';
import '../transitions/SlideOutTransition.js';
import '../Select/ValueContainer.js';
import '../DateTimePickers/TimeZonePicker/TimeZoneOption.js';
import '../DateTimePickers/DatePicker/DatePicker.js';
import '../Input/Input.js';
import '../DateTimePickers/DateTimePicker/DateTimePicker.js';
import '../List/AbstractList.js';
import 'react-table';
import '../InteractiveTable/ExpanderCell.js';
import '../../utils/dom.js';
import '../../utils/colors.js';
import 'slate';
import 'ansicolor';
import '../../utils/logger.js';
import '../Tags/Tag.js';
import '../Tags/TagList.js';
import '../Modal/Modal.js';
import '../QueryField/QueryField.js';
import '../Monaco/CodeEditor.js';
import 'react-use';
import '../Modal/getModalStyles.js';
import '../Tabs/Tab.js';
import '../Tabs/TabsBar.js';
import '../Modal/ModalsContext.js';
import 'rxjs';
import 'rxjs/operators';
import '../Table/Table.js';
import '@grafana/schema';
import '../TableInputCSV/TableInputCSV.js';
import '../Tabs/VerticalTab.js';
import '../Tabs/TabContent.js';
import '../Tabs/Counter.js';
import '../BigValue/BigValue.js';
import '../Sparkline/Sparkline.js';
import '../Gauge/Gauge.js';
import '../Graph/Graph.js';
import '../Graph/GraphWithLegend.js';
import '../ContextMenu/ContextMenu.js';
import '../FormattedValueDisplay/FormattedValueDisplay.js';
import '../Menu/MenuGroup.js';
import '../Menu/MenuItem.js';
import '../VizLegend/SeriesIcon.js';
import '../BarGauge/BarGauge.js';
import '../VizTooltip/VizTooltip.js';
import '../VizTooltip/VizTooltipContainer.js';
import '../VizRepeater/VizRepeater.js';
import '../PanelChrome/index.js';
import '../VizLayout/VizLayout.js';
import '../VizLegend/VizLegend.js';
import '../VizLegend/VizLegendListItem.js';
import '../Alert/Alert.js';
import '../Collapse/Collapse.js';
import '../Logs/LogMessageAnsi.js';
import '../Logs/LogRows.js';
import '../Button/FullWidthButtonContainer.js';
import '../ClickOutsideWrapper/ClickOutsideWrapper.js';
import '../Menu/Menu.js';
import '../DataLinks/DataLinksInlineEditor/DataLinksInlineEditor.js';
import '../DataLinks/DataLinkInput.js';
import '../InfoBox/InfoBox.js';
import '../InfoBox/FeatureInfoBox.js';
import '../JSONFormatter/JSONFormatter.js';
import '../ErrorBoundary/ErrorBoundary.js';
import '../ErrorBoundary/ErrorWithStack.js';
import '../Forms/InlineField.js';
import '../Switch/Switch.js';
import '../DataSourceSettings/CustomHeadersSettings.js';
import '../TextArea/TextArea.js';
import 'react-use/lib/useClickAway';
import '@react-aria/dialog';
import '@react-aria/focus';
import '@react-aria/overlays';
import 'rc-drawer';
import '../Slider/Slider.js';
import '../Slider/RangeSlider.js';
import 'react-hook-form';
import '../ToolbarButton/ToolbarButton.js';
import { ToolbarButtonRow } from '../ToolbarButton/ToolbarButtonRow.js';
import '../MatchersUI/fieldMatchersUI.js';
import { Link } from '../Link/Link.js';
import '../Forms/Label.js';
import '../Forms/Field.js';
import '../Forms/FieldSet.js';
import '../Forms/FieldValidationMessage.js';
import '../Forms/InlineSegmentGroup.js';
import '../Badge/Badge.js';
import '../Forms/RadioButtonGroup/RadioButtonGroup.js';
import '../Input/AutoSizeInput.js';
import '../FilterInput/FilterInput.js';
import '../Forms/Checkbox.js';
import 'uuid';
import 'react-dropzone';
import '../DateTimePickers/TimeRangeInput.js';
import '../DateTimePickers/RelativeTimeRangePicker/RelativeTimeRangePicker.js';
import '../Card/Card.js';
import '../Card/CardContainer.js';
import '../Dropdown/ButtonSelect.js';
import '../Dropdown/Dropdown.js';
import '../PluginSignatureBadge/PluginSignatureBadge.js';
import '../uPlot/config.js';
import 'uplot';
import '../uPlot/utils.js';
import 'tinycolor2';
import '../uPlot/PlotLegend.js';
import '../GraphNG/GraphNG.js';
import '../TimeSeries/TimeSeries.js';
import '../GraphNG/hooks.js';
import '../BrowserLabel/Label.js';

const PageToolbar = React__default.memo(
  ({
    title,
    section,
    parent,
    pageIcon,
    onGoBack,
    children,
    titleHref,
    parentHref,
    leftItems,
    isFullscreen,
    className,
    /** main nav-container aria-label **/
    "aria-label": ariaLabel,
    buttonOverflowAlignment = "right",
    forceShowLeftItems = false
  }) => {
    const styles = useStyles2(getStyles);
    const mainStyle = cx(
      "page-toolbar",
      styles.toolbar,
      {
        ["page-toolbar--fullscreen"]: isFullscreen,
        [styles.noPageIcon]: !pageIcon
      },
      className
    );
    const titleEl = /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, /* @__PURE__ */ React__default.createElement("span", { className: styles.truncateText }, title), section && /* @__PURE__ */ React__default.createElement("span", { className: styles.pre }, " / ", section));
    return /* @__PURE__ */ React__default.createElement("nav", { className: mainStyle, "aria-label": ariaLabel }, /* @__PURE__ */ React__default.createElement("div", { className: styles.leftWrapper }, pageIcon && !onGoBack && /* @__PURE__ */ React__default.createElement("div", { className: styles.pageIcon }, /* @__PURE__ */ React__default.createElement(Icon, { name: pageIcon, size: "lg", "aria-hidden": true })), onGoBack && /* @__PURE__ */ React__default.createElement("div", { className: styles.pageIcon }, /* @__PURE__ */ React__default.createElement(
      IconButton,
      {
        name: "arrow-left",
        tooltip: "Go back (Esc)",
        tooltipPlacement: "bottom",
        size: "xxl",
        "aria-label": selectors.components.BackButton.backArrow,
        onClick: onGoBack
      }
    )), /* @__PURE__ */ React__default.createElement("nav", { "aria-label": "Search links", className: styles.navElement }, parent && parentHref && /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, /* @__PURE__ */ React__default.createElement(
      Link,
      {
        "aria-label": `Search dashboard in the ${parent} folder`,
        className: cx(styles.titleText, styles.parentLink, styles.titleLink, styles.truncateText),
        href: parentHref
      },
      parent,
      " ",
      /* @__PURE__ */ React__default.createElement("span", { className: styles.parentIcon })
    ), titleHref && /* @__PURE__ */ React__default.createElement("span", { className: cx(styles.titleText, styles.titleDivider), "aria-hidden": true }, "/")), (title || Boolean(leftItems == null ? void 0 : leftItems.length)) && /* @__PURE__ */ React__default.createElement("div", { className: styles.titleWrapper }, title && /* @__PURE__ */ React__default.createElement("h1", { className: styles.h1Styles }, titleHref ? /* @__PURE__ */ React__default.createElement(
      Link,
      {
        "aria-label": "Search dashboard by name",
        className: cx(styles.titleText, styles.titleLink),
        href: titleHref
      },
      titleEl
    ) : /* @__PURE__ */ React__default.createElement("div", { className: styles.titleText }, titleEl)), leftItems == null ? void 0 : leftItems.map((child, index) => /* @__PURE__ */ React__default.createElement(
      "div",
      {
        className: cx(styles.leftActionItem, { [styles.forceShowLeftActionItems]: forceShowLeftItems }),
        key: index
      },
      child
    ))))), /* @__PURE__ */ React__default.createElement(ToolbarButtonRow, { alignment: buttonOverflowAlignment }, React__default.Children.toArray(children).filter(Boolean)));
  }
);
PageToolbar.displayName = "PageToolbar";
const getStyles = (theme) => {
  const { spacing, typography } = theme;
  const focusStyle = getFocusStyles(theme);
  return {
    pre: css`
      white-space: pre;
    `,
    toolbar: css`
      align-items: center;
      background: ${theme.colors.background.canvas};
      display: flex;
      gap: ${theme.spacing(2)};
      justify-content: space-between;
      padding: ${theme.spacing(1.5, 2)};

      ${theme.breakpoints.down("md")} {
        padding-left: 53px;
      }
    `,
    noPageIcon: css`
      ${theme.breakpoints.down("md")} {
        padding-left: ${theme.spacing(2)};
      }
    `,
    leftWrapper: css`
      display: flex;
      flex-wrap: nowrap;
      max-width: 70%;
    `,
    pageIcon: css`
      display: none;
      ${theme.breakpoints.up("sm")} {
        display: flex;
        padding-right: ${theme.spacing(1)};
        align-items: center;
      }
    `,
    truncateText: css`
      overflow: hidden;
      text-overflow: ellipsis;
      white-space: nowrap;
    `,
    titleWrapper: css`
      display: flex;
      margin: 0;
      min-width: 0;
    `,
    navElement: css`
      display: flex;
      align-items: center;
      min-width: 0;
    `,
    h1Styles: css`
      margin: ${spacing(0, 1, 0, 0)};
      line-height: inherit;
      flex-grow: 1;
      min-width: 0;
    `,
    parentIcon: css`
      margin-left: ${theme.spacing(0.5)};
    `,
    titleText: css`
      display: flex;
      font-size: ${typography.size.lg};
      margin: 0;
      max-width: 300px;
      border-radius: ${theme.shape.radius.default};
    `,
    titleLink: css`
      &:focus-visible {
        ${focusStyle}
      }
    `,
    titleDivider: css`
      padding: ${spacing(0, 0.5, 0, 0.5)};
      display: none;
      ${theme.breakpoints.up("md")} {
        display: unset;
      }
    `,
    parentLink: css`
      display: none;
      ${theme.breakpoints.up("md")} {
        display: unset;
        flex: 1;
      }
    `,
    leftActionItem: css`
      display: none;
      align-items: center;
      padding-right: ${spacing(0.5)};
      ${theme.breakpoints.up("md")} {
        display: flex;
      }
    `,
    forceShowLeftActionItems: css`
      display: flex;
    `
  };
};

export { PageToolbar };
//# sourceMappingURL=PageToolbar.js.map
