import { cx, css } from '@emotion/css';
import memoizeOne from 'memoize-one';
import React__default, { PureComponent } from 'react';
import { getParser, calculateFieldStats, calculateLogsLabelStats, calculateStats } from '@grafana/data';
import { withTheme2 } from '../../themes/ThemeContext.js';
import '@emotion/react';
import 'tinycolor2';
import { Icon } from '../Icon/Icon.js';
import { Tooltip } from '../Tooltip/Tooltip.js';
import { LogDetailsRow } from './LogDetailsRow.js';
import { getLogRowStyles } from './getLogRowStyles.js';
import { getAllFields } from './logParser.js';

const getStyles = (theme) => {
  return {
    logsRowLevelDetails: css`
      label: logs-row__level_details;
      &::after {
        top: -3px;
      }
    `,
    logDetails: css`
      label: logDetailsDefaultCursor;
      cursor: default;

      &:hover {
        background-color: ${theme.colors.background.primary};
      }
    `
  };
};
class UnThemedLogDetails extends PureComponent {
  constructor() {
    super(...arguments);
    this.getParser = memoizeOne(getParser);
    this.getStatsForDetectedField = (key) => {
      const matcher = this.getParser(this.props.row.entry).buildMatcher(key);
      return calculateFieldStats(this.props.getRows(), matcher);
    };
  }
  render() {
    const {
      row,
      theme,
      hasError,
      onClickFilterOutLabel,
      onClickFilterLabel,
      getRows,
      showDuplicates,
      className,
      onClickShowDetectedField,
      onClickHideDetectedField,
      showDetectedFields,
      getFieldLinks,
      wrapLogMessage
    } = this.props;
    const style = getLogRowStyles(theme, row.logLevel);
    const styles = getStyles(theme);
    const labels = row.labels ? row.labels : {};
    const labelsAvailable = Object.keys(labels).length > 0;
    const fields = getAllFields(row, getFieldLinks);
    const detectedFieldsAvailable = fields && fields.length > 0;
    const levelClassName = cx(!hasError && [style.logsRowLevel, styles.logsRowLevelDetails]);
    return /* @__PURE__ */ React__default.createElement("tr", { className: cx(className, styles.logDetails) }, showDuplicates && /* @__PURE__ */ React__default.createElement("td", null), /* @__PURE__ */ React__default.createElement("td", { className: levelClassName, "aria-label": "Log level" }), /* @__PURE__ */ React__default.createElement("td", { colSpan: 4 }, /* @__PURE__ */ React__default.createElement("div", { className: style.logDetailsContainer }, /* @__PURE__ */ React__default.createElement("table", { className: style.logDetailsTable }, /* @__PURE__ */ React__default.createElement("tbody", null, labelsAvailable && /* @__PURE__ */ React__default.createElement("tr", null, /* @__PURE__ */ React__default.createElement("td", { colSpan: 5, className: style.logDetailsHeading, "aria-label": "Log labels" }, "Log labels")), Object.keys(labels).sort().map((key) => {
      const value = labels[key];
      return /* @__PURE__ */ React__default.createElement(
        LogDetailsRow,
        {
          key: `${key}=${value}`,
          parsedKey: key,
          parsedValue: value,
          isLabel: true,
          getStats: () => calculateLogsLabelStats(getRows(), key),
          onClickFilterOutLabel,
          onClickFilterLabel
        }
      );
    }), detectedFieldsAvailable && /* @__PURE__ */ React__default.createElement("tr", null, /* @__PURE__ */ React__default.createElement("td", { colSpan: 5, className: style.logDetailsHeading, "aria-label": "Detected fields" }, "Detected fields", /* @__PURE__ */ React__default.createElement(Tooltip, { content: "Fields that are parsed from log message and detected by Grafana." }, /* @__PURE__ */ React__default.createElement(
      Icon,
      {
        name: "question-circle",
        size: "xs",
        className: css`
                            margin-left: 4px;
                          `
      }
    )))), fields.sort().map((field) => {
      const { key, value, links, fieldIndex } = field;
      return /* @__PURE__ */ React__default.createElement(
        LogDetailsRow,
        {
          key: `${key}=${value}`,
          parsedKey: key,
          parsedValue: value,
          links,
          onClickShowDetectedField,
          onClickHideDetectedField,
          getStats: () => fieldIndex === void 0 ? this.getStatsForDetectedField(key) : calculateStats(row.dataFrame.fields[fieldIndex].values.toArray()),
          showDetectedFields,
          wrapLogMessage
        }
      );
    }), !detectedFieldsAvailable && !labelsAvailable && /* @__PURE__ */ React__default.createElement("tr", null, /* @__PURE__ */ React__default.createElement("td", { colSpan: 5, "aria-label": "No details" }, "No details available")))))));
  }
}
const LogDetails = withTheme2(UnThemedLogDetails);
LogDetails.displayName = "LogDetails";

export { LogDetails };
//# sourceMappingURL=LogDetails.js.map
