import { cx, css } from '@emotion/css';
import React__default from 'react';
import { colorManipulator } from '@grafana/data';
import { useTheme2 } from '../../themes/ThemeContext.js';
import { getFocusStyles, getMouseFocusStyles } from '../../themes/mixins.js';
import { stylesFactory } from '../../themes/stylesFactory.js';
import { Icon } from '../Icon/Icon.js';
import { getSvgSize } from '../Icon/utils.js';
import { Tooltip } from '../Tooltip/Tooltip.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const IconButton = React__default.forwardRef(
  (_a, ref) => {
    var _b = _a, {
      name,
      size = "md",
      iconType,
      tooltip,
      tooltipPlacement,
      ariaLabel,
      className,
      variant = "secondary"
    } = _b, restProps = __objRest(_b, [
      "name",
      "size",
      "iconType",
      "tooltip",
      "tooltipPlacement",
      "ariaLabel",
      "className",
      "variant"
    ]);
    const theme = useTheme2();
    const styles = getStyles(theme, size, variant);
    const tooltipString = typeof tooltip === "string" ? tooltip : "";
    const button = /* @__PURE__ */ React__default.createElement("button", __spreadProps(__spreadValues({ ref, "aria-label": ariaLabel || tooltipString }, restProps), { className: cx(styles.button, className) }), /* @__PURE__ */ React__default.createElement(Icon, { name, size, className: styles.icon, type: iconType }));
    if (tooltip) {
      return /* @__PURE__ */ React__default.createElement(Tooltip, { content: tooltip, placement: tooltipPlacement }, button);
    }
    return button;
  }
);
IconButton.displayName = "IconButton";
const getStyles = stylesFactory((theme, size, variant) => {
  const pixelSize = getSvgSize(size);
  const hoverSize = Math.max(pixelSize / 3, 8);
  let iconColor = theme.colors.text.primary;
  if (variant === "primary") {
    iconColor = theme.colors.primary.text;
  } else if (variant === "destructive") {
    iconColor = theme.colors.error.text;
  }
  return {
    button: css`
      width: ${pixelSize}px;
      height: ${pixelSize}px;
      background: transparent;
      border: none;
      color: ${iconColor};
      padding: 0;
      margin: 0;
      outline: none;
      box-shadow: none;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      position: relative;
      border-radius: ${theme.shape.borderRadius()};
      z-index: 0;
      margin-right: ${theme.spacing(0.5)};

      &[disabled],
      &:disabled {
        cursor: not-allowed;
        color: ${theme.colors.action.disabledText};
        opacity: 0.65;
        box-shadow: none;
      }

      &:before {
        content: '';
        display: block;
        opacity: 1;
        position: absolute;
        transition-duration: 0.2s;
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        z-index: -1;
        bottom: -${hoverSize}px;
        left: -${hoverSize}px;
        right: -${hoverSize}px;
        top: -${hoverSize}px;
        background: none;
        border-radius: 50%;
        box-sizing: border-box;
        transform: scale(0);
        transition-property: transform, opacity;
      }

      &:focus,
      &:focus-visible {
        ${getFocusStyles(theme)}
      }

      &:focus:not(:focus-visible) {
        ${getMouseFocusStyles()}
      }

      &:hover {
        color: ${iconColor};

        &:before {
          background-color: ${variant === "secondary" ? theme.colors.action.hover : colorManipulator.alpha(iconColor, 0.12)};
          border: none;
          box-shadow: none;
          opacity: 1;
          transform: scale(0.8);
        }
      }
    `,
    icon: css`
      vertical-align: baseline;
      display: flex;
    `
  };
});

export { IconButton };
//# sourceMappingURL=IconButton.js.map
