import { cx, css } from '@emotion/css';
import React__default from 'react';
import SVG from 'react-inlinesvg';
import { isIconName } from '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import { cacheInitialized, initIconCache, iconRoot } from './iconBundle.js';
import { getIconSubDir, getSvgSize } from './utils.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getIconStyles = (theme) => {
  return {
    // line-height: 0; is needed for correct icon alignment in Safari
    container: css`
      label: Icon;
      display: inline-block;
      line-height: 0;
    `,
    icon: css`
      vertical-align: middle;
      display: inline-block;
      fill: currentColor;
    `,
    orange: css`
      fill: ${theme.v1.palette.orange};
    `
  };
};
const Icon = React__default.forwardRef(
  (_a, ref) => {
    var _b = _a, { size = "md", type = "default", name, className, style, title = "" } = _b, divElementProps = __objRest(_b, ["size", "type", "name", "className", "style", "title"]);
    const styles = useStyles2(getIconStyles);
    if (name == null ? void 0 : name.startsWith("fa fa-")) {
      return /* @__PURE__ */ React__default.createElement("i", __spreadProps(__spreadValues({ className: getFontAwesomeIconStyles(name, className) }, divElementProps), { style }));
    }
    if (!cacheInitialized) {
      initIconCache();
    }
    if (!isIconName(name)) {
      console.warn("Icon component passed an invalid icon name", name);
    }
    if (!name || name.includes("..")) {
      return /* @__PURE__ */ React__default.createElement("div", { ref }, "invalid icon name");
    }
    const svgSize = getSvgSize(size);
    const svgHgt = svgSize;
    const svgWid = name.startsWith("gf-bar-align") ? 16 : name.startsWith("gf-interp") ? 30 : svgSize;
    const subDir = getIconSubDir(name, type);
    const svgPath = `${iconRoot}${subDir}/${name}.svg`;
    return /* @__PURE__ */ React__default.createElement("div", __spreadProps(__spreadValues({ className: styles.container }, divElementProps), { ref }), /* @__PURE__ */ React__default.createElement(
      SVG,
      {
        src: svgPath,
        width: svgWid,
        height: svgHgt,
        title,
        className: cx(styles.icon, className, type === "mono" ? { [styles.orange]: name === "favorite" } : ""),
        style
      }
    ));
  }
);
Icon.displayName = "Icon";
function getFontAwesomeIconStyles(iconName, className) {
  return cx(
    iconName,
    {
      "fa-spin": iconName === "fa fa-spinner"
    },
    className
  );
}

export { Icon };
//# sourceMappingURL=Icon.js.map
