import { cx, css } from '@emotion/css';
import React__default from 'react';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { clearButtonStyles } from '../Button/Button.js';
import '../Button/ButtonGroup.js';
import { Icon } from '../Icon/Icon.js';

const FilterPill = ({ label, selected, onClick, icon = "check" }) => {
  const styles = useStyles2(getStyles);
  const clearButton = useStyles2(clearButtonStyles);
  return /* @__PURE__ */ React__default.createElement("button", { type: "button", className: cx(clearButton, styles.wrapper, selected && styles.selected), onClick }, /* @__PURE__ */ React__default.createElement("span", null, label), selected && /* @__PURE__ */ React__default.createElement(Icon, { name: icon, className: styles.icon }));
};
const getStyles = (theme) => {
  return {
    wrapper: css`
      background: ${theme.colors.background.secondary};
      border-radius: ${theme.shape.borderRadius(8)};
      padding: ${theme.spacing(0, 2)};
      font-size: ${theme.typography.bodySmall.fontSize};
      font-weight: ${theme.typography.fontWeightMedium};
      line-height: ${theme.typography.bodySmall.lineHeight};
      color: ${theme.colors.text.secondary};
      display: flex;
      align-items: center;
      height: 32px;

      &:hover {
        background: ${theme.colors.action.hover};
        color: ${theme.colors.text.primary};
      }
    `,
    selected: css`
      color: ${theme.colors.text.primary};
      background: ${theme.colors.action.selected};

      &:hover {
        background: ${theme.colors.action.focus};
      }
    `,
    icon: css`
      margin-left: ${theme.spacing(0.5)};
    `
  };
};

export { FilterPill };
//# sourceMappingURL=FilterPill.js.map
