import { css } from '@emotion/css';
import React__default from 'react';
import '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';

const getStyles = stylesFactory(() => {
  return css`
    width: 500px;
    margin: 64px auto;
  `;
});
const ErrorWithStack = ({ error, errorInfo, title }) => /* @__PURE__ */ React__default.createElement("div", { className: getStyles() }, /* @__PURE__ */ React__default.createElement("h2", null, title), /* @__PURE__ */ React__default.createElement("details", { style: { whiteSpace: "pre-wrap" } }, error && error.toString(), /* @__PURE__ */ React__default.createElement("br", null), errorInfo && errorInfo.componentStack));
ErrorWithStack.displayName = "ErrorWithStack";

export { ErrorWithStack };
//# sourceMappingURL=ErrorWithStack.js.map
