import { css } from '@emotion/css';
import React__default from 'react';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';

const EmptySearchResult = ({ children }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ React__default.createElement("div", { className: styles.container }, children);
};
const getStyles = (theme) => {
  return {
    container: css`
      border-left: 3px solid ${theme.colors.info.main};
      background-color: ${theme.colors.background.secondary};
      padding: ${theme.spacing(2)};
      min-width: 350px;
      border-radius: ${theme.shape.radius.default};
      margin-bottom: ${theme.spacing(4)};
    `
  };
};

export { EmptySearchResult };
//# sourceMappingURL=EmptySearchResult.js.map
