import { css } from '@emotion/css';
import { useDialog } from '@react-aria/dialog';
import { FocusScope } from '@react-aria/focus';
import { useOverlay } from '@react-aria/overlays';
import RcDrawer from 'rc-drawer';
import React__default, { useState, useEffect } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { CustomScrollbar } from '../CustomScrollbar/CustomScrollbar.js';
import { IconButton } from '../IconButton/IconButton.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
function Drawer({
  children,
  inline = false,
  onClose,
  closeOnMaskClick = true,
  scrollableContent = false,
  title,
  subtitle,
  width = "40%",
  expandable = false,
  tabs
}) {
  const drawerStyles = useStyles2(getStyles);
  const [isExpanded, setIsExpanded] = useState(false);
  const [isOpen, setIsOpen] = useState(false);
  const currentWidth = isExpanded ? "100%" : width;
  const overlayRef = React__default.useRef(null);
  const { dialogProps, titleProps } = useDialog({}, overlayRef);
  const { overlayProps } = useOverlay(
    {
      isDismissable: false,
      isOpen,
      onClose
    },
    overlayRef
  );
  useEffect(() => {
    setIsOpen(true);
  }, []);
  const content = /* @__PURE__ */ React__default.createElement("div", { className: drawerStyles.content }, children);
  const style = {};
  if (inline) {
    style.position = "absolute";
  }
  return /* @__PURE__ */ React__default.createElement(
    RcDrawer,
    {
      open: isOpen,
      onClose,
      placement: "right",
      width: currentWidth,
      getContainer: inline ? void 0 : "body",
      style,
      className: drawerStyles.drawerContent,
      rootClassName: drawerStyles.drawer,
      motion: {
        motionAppear: true,
        motionName: drawerStyles.drawerMotion
      },
      maskClassName: drawerStyles.mask,
      maskClosable: closeOnMaskClick,
      maskMotion: {
        motionAppear: true,
        motionName: drawerStyles.maskMotion
      }
    },
    /* @__PURE__ */ React__default.createElement(FocusScope, { restoreFocus: true, contain: true, autoFocus: true }, /* @__PURE__ */ React__default.createElement(
      "div",
      __spreadProps(__spreadValues(__spreadValues({
        "aria-label": typeof title === "string" ? selectors.components.Drawer.General.title(title) : selectors.components.Drawer.General.title("no title"),
        className: drawerStyles.container
      }, overlayProps), dialogProps), {
        ref: overlayRef
      }),
      typeof title === "string" && /* @__PURE__ */ React__default.createElement("div", { className: drawerStyles.header }, /* @__PURE__ */ React__default.createElement("div", { className: drawerStyles.actions }, expandable && !isExpanded && /* @__PURE__ */ React__default.createElement(
        IconButton,
        {
          name: "angle-left",
          size: "xl",
          onClick: () => setIsExpanded(true),
          "aria-label": selectors.components.Drawer.General.expand
        }
      ), expandable && isExpanded && /* @__PURE__ */ React__default.createElement(
        IconButton,
        {
          name: "angle-right",
          size: "xl",
          onClick: () => setIsExpanded(false),
          "aria-label": selectors.components.Drawer.General.contract
        }
      ), /* @__PURE__ */ React__default.createElement(
        IconButton,
        {
          name: "times",
          size: "xl",
          onClick: onClose,
          "aria-label": selectors.components.Drawer.General.close
        }
      )), /* @__PURE__ */ React__default.createElement("div", { className: drawerStyles.titleWrapper }, /* @__PURE__ */ React__default.createElement("h3", __spreadValues({}, titleProps), title), typeof subtitle === "string" && /* @__PURE__ */ React__default.createElement("div", { className: "muted" }, subtitle), typeof subtitle !== "string" && subtitle, tabs && /* @__PURE__ */ React__default.createElement("div", { className: drawerStyles.tabsWrapper }, tabs))),
      typeof title !== "string" && title,
      /* @__PURE__ */ React__default.createElement("div", { className: drawerStyles.contentScroll }, !scrollableContent ? content : /* @__PURE__ */ React__default.createElement(CustomScrollbar, { autoHeightMin: "100%" }, content))
    ))
  );
}
const getStyles = (theme) => {
  return {
    container: css`
      display: flex;
      flex-direction: column;
      height: 100%;
      flex: 1 1 0;
    `,
    drawer: css`
      .rc-drawer-content-wrapper {
        box-shadow: ${theme.shadows.z3};

        ${theme.breakpoints.down("sm")} {
          width: 100% !important;
        }
      }
    `,
    drawerContent: css`
      background-color: ${theme.colors.background.primary} !important;
      display: flex;
      flex-direction: column;
      overflow: hidden;
      z-index: ${theme.zIndex.dropdown};
    `,
    drawerMotion: css`
      &-appear {
        transform: translateX(100%);
        transition: none !important;

        &-active {
          transition: ${theme.transitions.create("transform")} !important;
          transform: translateX(0);
        }
      }
    `,
    mask: css`
      background-color: ${theme.components.overlay.background} !important;
      backdrop-filter: blur(1px);
    `,
    maskMotion: css`
      &-appear {
        opacity: 0;

        &-active {
          opacity: 1;
          transition: ${theme.transitions.create("opacity")};
        }
      }
    `,
    header: css`
      background-color: ${theme.colors.background.canvas};
      flex-grow: 0;
      padding-top: ${theme.spacing(0.5)};
    `,
    actions: css`
      display: flex;
      align-items: baseline;
      justify-content: flex-end;
    `,
    titleWrapper: css`
      margin-bottom: ${theme.spacing(3)};
      padding: ${theme.spacing(0, 1, 0, 3)};
      overflow-wrap: break-word;
    `,
    content: css({
      padding: theme.spacing(2),
      height: "100%",
      flexGrow: 1
    }),
    contentScroll: css({
      minHeight: 0,
      flex: 1
    }),
    tabsWrapper: css({
      paddingLeft: theme.spacing(2),
      margin: theme.spacing(3, -1, -3, -3)
    })
  };
};

export { Drawer };
//# sourceMappingURL=Drawer.js.map
