import { css, cx } from '@emotion/css';
import { isString } from 'lodash';
import React__default from 'react';
import { getTimeZoneInfo } from '@grafana/data';
import { useTheme2 } from '../../../themes/ThemeContext.js';
import { stylesFactory } from '../../../themes/stylesFactory.js';
import { Icon } from '../../Icon/Icon.js';
import { TimeZoneDescription } from './TimeZoneDescription.js';
import { TimeZoneOffset } from './TimeZoneOffset.js';
import { TimeZoneTitle } from './TimeZoneTitle.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const offsetClassName = "tz-utc-offset";
const WideTimeZoneOption = (props) => {
  const { children, innerProps, innerRef, data, isSelected, isFocused } = props;
  const theme = useTheme2();
  const styles = getStyles(theme);
  const timestamp = Date.now();
  const containerStyles = cx(styles.container, isFocused && styles.containerFocused);
  if (!isString(data.value)) {
    return null;
  }
  const timeZoneInfo = getTimeZoneInfo(data.value, timestamp);
  return /* @__PURE__ */ React__default.createElement("div", __spreadProps(__spreadValues({ className: containerStyles }, innerProps), { ref: innerRef, "aria-label": "Select option" }), /* @__PURE__ */ React__default.createElement("div", { className: cx(styles.leftColumn, styles.row) }, /* @__PURE__ */ React__default.createElement("div", { className: cx(styles.leftColumn, styles.wideRow) }, /* @__PURE__ */ React__default.createElement(TimeZoneTitle, { title: children }), /* @__PURE__ */ React__default.createElement("div", { className: styles.spacer }), /* @__PURE__ */ React__default.createElement(TimeZoneDescription, { info: timeZoneInfo })), /* @__PURE__ */ React__default.createElement("div", { className: styles.rightColumn }, /* @__PURE__ */ React__default.createElement(
    TimeZoneOffset,
    {
      timeZone: (timeZoneInfo == null ? void 0 : timeZoneInfo.ianaName) || data.value,
      timestamp,
      className: offsetClassName
    }
  ), isSelected && /* @__PURE__ */ React__default.createElement("span", null, /* @__PURE__ */ React__default.createElement(Icon, { name: "check" })))));
};
const CompactTimeZoneOption = (props) => {
  const { children, innerProps, innerRef, data, isSelected, isFocused } = props;
  const theme = useTheme2();
  const styles = getStyles(theme);
  const timestamp = Date.now();
  const containerStyles = cx(styles.container, isFocused && styles.containerFocused);
  if (!isString(data.value)) {
    return null;
  }
  const timeZoneInfo = getTimeZoneInfo(data.value, timestamp);
  return /* @__PURE__ */ React__default.createElement("div", __spreadProps(__spreadValues({ className: containerStyles }, innerProps), { ref: innerRef, "aria-label": "Select option" }), /* @__PURE__ */ React__default.createElement("div", { className: styles.body }, /* @__PURE__ */ React__default.createElement("div", { className: styles.row }, /* @__PURE__ */ React__default.createElement("div", { className: styles.leftColumn }, /* @__PURE__ */ React__default.createElement(TimeZoneTitle, { title: children })), /* @__PURE__ */ React__default.createElement("div", { className: styles.rightColumn }, isSelected && /* @__PURE__ */ React__default.createElement("span", null, /* @__PURE__ */ React__default.createElement(Icon, { name: "check" })))), /* @__PURE__ */ React__default.createElement("div", { className: styles.row }, /* @__PURE__ */ React__default.createElement("div", { className: styles.leftColumn }, /* @__PURE__ */ React__default.createElement(TimeZoneDescription, { info: timeZoneInfo })), /* @__PURE__ */ React__default.createElement("div", { className: styles.rightColumn }, /* @__PURE__ */ React__default.createElement(
    TimeZoneOffset,
    {
      timestamp,
      timeZone: (timeZoneInfo == null ? void 0 : timeZoneInfo.ianaName) || data.value,
      className: offsetClassName
    }
  )))));
};
const getStyles = stylesFactory((theme) => {
  return {
    container: css`
      display: flex;
      align-items: center;
      flex-direction: row;
      flex-shrink: 0;
      white-space: nowrap;
      cursor: pointer;
      padding: 6px 8px 4px;

      &:hover {
        background: ${theme.colors.action.hover};
      }
    `,
    containerFocused: css`
      background: ${theme.colors.action.hover};
    `,
    body: css`
      display: flex;
      font-weight: ${theme.typography.fontWeightMedium};
      flex-direction: column;
      flex-grow: 1;
    `,
    row: css`
      display: flex;
      flex-direction: row;
    `,
    leftColumn: css`
      flex-grow: 1;
      text-overflow: ellipsis;
    `,
    rightColumn: css`
      justify-content: flex-end;
      align-items: center;
    `,
    wideRow: css`
      display: flex;
      flex-direction: row;
      align-items: baseline;
    `,
    spacer: css`
      margin-left: 6px;
    `
  };
});

export { CompactTimeZoneOption, WideTimeZoneOption };
//# sourceMappingURL=TimeZoneOption.js.map
