import { css, cx } from '@emotion/css';
import { isString } from 'lodash';
import React__default, { useState, useCallback } from 'react';
import { getTimeZoneInfo } from '@grafana/data';
import { selectors } from '@grafana/e2e-selectors';
import '../../FormField/FormField.js';
import '../../Forms/Legacy/Input/Input.js';
import 'react-select';
import '../../Icon/Icon.js';
import '../../Forms/Legacy/Select/Select.js';
import '../../Tooltip/Tooltip.js';
import '../../SecretFormField/SecretFormField.js';
import '../../IconButton/IconButton.js';
import '../../ConfirmButton/ConfirmButton.js';
import { Button } from '../../Button/Button.js';
import '../../Button/ButtonGroup.js';
import 'react-popper';
import 'react-transition-group/Transition';
import '../../Portal/Portal.js';
import '../../Toggletip/Toggletip.js';
import 'react-custom-scrollbars-2';
import { useTheme2 } from '../../../themes/ThemeContext.js';
import { stylesFactory } from '../../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';
import 'classnames';
import '../../TabbedContainer/TabbedContainer.js';
import { t, Trans } from '../../../utils/i18n.js';
import '../../Cascader/Cascader.js';
import '../../ButtonCascader/ButtonCascader.js';
import '../../Spinner/Spinner.js';
import '../../ColorPicker/ColorPicker.js';
import '../../ColorPicker/ColorPickerInput.js';
import '../../ColorPicker/SeriesColorPickerPopover.js';
import '../../StatsPicker/StatsPicker.js';
import '../../RefreshPicker/RefreshPicker.js';
import '../TimeRangePicker.js';
import 'rc-time-picker';
import { TimeZonePicker } from '../TimeZonePicker.js';
import { Select } from '../../Select/Select.js';
import '../DatePicker/DatePicker.js';
import '../../Input/Input.js';
import '../DateTimePicker/DateTimePicker.js';
import '../../List/AbstractList.js';
import 'react-table';
import '../../InteractiveTable/ExpanderCell.js';
import '../../../utils/dom.js';
import '../../../utils/colors.js';
import 'slate';
import 'ansicolor';
import '../../../utils/logger.js';
import '../../Tags/Tag.js';
import '../../Tags/TagList.js';
import '../../Modal/Modal.js';
import '../../QueryField/QueryField.js';
import '../../Monaco/CodeEditor.js';
import 'react-use';
import '../../Modal/getModalStyles.js';
import '../../Tabs/Tab.js';
import '../../Tabs/TabsBar.js';
import '../../Modal/ModalsContext.js';
import '../../PageLayout/PageToolbar.js';
import 'rxjs';
import 'rxjs/operators';
import '../../Table/Table.js';
import '@grafana/schema';
import '../../TableInputCSV/TableInputCSV.js';
import '../../Tabs/VerticalTab.js';
import '../../Tabs/TabContent.js';
import '../../Tabs/Counter.js';
import '../../BigValue/BigValue.js';
import '../../Sparkline/Sparkline.js';
import '../../Gauge/Gauge.js';
import '../../Graph/Graph.js';
import '../../Graph/GraphWithLegend.js';
import '../../ContextMenu/ContextMenu.js';
import '../../FormattedValueDisplay/FormattedValueDisplay.js';
import '../../Menu/MenuGroup.js';
import '../../Menu/MenuItem.js';
import '../../VizLegend/SeriesIcon.js';
import '../../BarGauge/BarGauge.js';
import '../../VizTooltip/VizTooltip.js';
import '../../VizTooltip/VizTooltipContainer.js';
import '../../VizRepeater/VizRepeater.js';
import '../../PanelChrome/index.js';
import '../../VizLayout/VizLayout.js';
import '../../VizLegend/VizLegend.js';
import '../../VizLegend/VizLegendListItem.js';
import '../../Alert/Alert.js';
import '../../Collapse/Collapse.js';
import '../../Logs/LogMessageAnsi.js';
import '../../Logs/LogRows.js';
import '../../Button/FullWidthButtonContainer.js';
import '../../ClickOutsideWrapper/ClickOutsideWrapper.js';
import '../../Menu/Menu.js';
import '../../DataLinks/DataLinksInlineEditor/DataLinksInlineEditor.js';
import '../../DataLinks/DataLinkInput.js';
import '../../InfoBox/InfoBox.js';
import '../../InfoBox/FeatureInfoBox.js';
import '../../JSONFormatter/JSONFormatter.js';
import '../../ErrorBoundary/ErrorBoundary.js';
import '../../ErrorBoundary/ErrorWithStack.js';
import '../../Forms/InlineField.js';
import '../../Switch/Switch.js';
import '../../DataSourceSettings/CustomHeadersSettings.js';
import '../../TextArea/TextArea.js';
import '../../transitions/FadeTransition.js';
import '../../transitions/SlideOutTransition.js';
import 'react-use/lib/useClickAway';
import '@react-aria/dialog';
import '@react-aria/focus';
import '@react-aria/overlays';
import 'rc-drawer';
import '../../Slider/Slider.js';
import '../../Slider/RangeSlider.js';
import 'react-hook-form';
import '../../ToolbarButton/ToolbarButton.js';
import '../../ToolbarButton/ToolbarButtonRow.js';
import '../../MatchersUI/fieldMatchersUI.js';
import '../../Link/Link.js';
import '../../Forms/Label.js';
import { Field } from '../../Forms/Field.js';
import '../../Forms/FieldSet.js';
import '../../Forms/FieldValidationMessage.js';
import '../../Forms/InlineSegmentGroup.js';
import '../../Select/getSelectStyles.js';
import '../../Badge/Badge.js';
import { RadioButtonGroup } from '../../Forms/RadioButtonGroup/RadioButtonGroup.js';
import '../../Input/AutoSizeInput.js';
import '../../FilterInput/FilterInput.js';
import '../../Forms/Checkbox.js';
import 'uuid';
import 'react-dropzone';
import '../TimeRangeInput.js';
import '../RelativeTimeRangePicker/RelativeTimeRangePicker.js';
import '../../Card/Card.js';
import '../../Card/CardContainer.js';
import '../../Dropdown/ButtonSelect.js';
import '../../Dropdown/Dropdown.js';
import '../../PluginSignatureBadge/PluginSignatureBadge.js';
import '../../uPlot/config.js';
import 'uplot';
import '../../uPlot/utils.js';
import '../../uPlot/PlotLegend.js';
import '../../GraphNG/GraphNG.js';
import '../../TimeSeries/TimeSeries.js';
import '../../GraphNG/hooks.js';
import '../../BrowserLabel/Label.js';
import { TimeZoneDescription } from '../TimeZonePicker/TimeZoneDescription.js';
import { TimeZoneOffset } from '../TimeZonePicker/TimeZoneOffset.js';
import { TimeZoneTitle } from '../TimeZonePicker/TimeZoneTitle.js';
import { monthOptions } from '../options.js';

const TimePickerFooter = (props) => {
  const {
    timeZone,
    fiscalYearStartMonth,
    timestamp = Date.now(),
    onChangeTimeZone,
    onChangeFiscalYearStartMonth
  } = props;
  const [isEditing, setEditing] = useState(false);
  const [editMode, setEditMode] = useState("tz");
  const onToggleChangeTimeSettings = useCallback(
    (event) => {
      if (event) {
        event.stopPropagation();
      }
      setEditing(!isEditing);
    },
    [isEditing, setEditing]
  );
  const theme = useTheme2();
  const style = getStyle(theme);
  if (!isString(timeZone)) {
    return null;
  }
  const info = getTimeZoneInfo(timeZone, timestamp);
  if (!info) {
    return null;
  }
  return /* @__PURE__ */ React__default.createElement("div", null, /* @__PURE__ */ React__default.createElement(
    "section",
    {
      "aria-label": t("time-picker.footer.time-zone-selection", "Time zone selection"),
      className: style.container
    },
    /* @__PURE__ */ React__default.createElement("div", { className: style.timeZoneContainer }, /* @__PURE__ */ React__default.createElement("div", { className: style.timeZone }, /* @__PURE__ */ React__default.createElement(TimeZoneTitle, { title: info.name }), /* @__PURE__ */ React__default.createElement("div", { className: style.spacer }), /* @__PURE__ */ React__default.createElement(TimeZoneDescription, { info })), /* @__PURE__ */ React__default.createElement(TimeZoneOffset, { timeZone, timestamp })),
    /* @__PURE__ */ React__default.createElement("div", { className: style.spacer }),
    /* @__PURE__ */ React__default.createElement(Button, { variant: "secondary", onClick: onToggleChangeTimeSettings, size: "sm" }, /* @__PURE__ */ React__default.createElement(Trans, { i18nKey: "time-picker.footer.change-settings-button" }, "Change time settings"))
  ), isEditing ? /* @__PURE__ */ React__default.createElement("div", { className: style.editContainer }, /* @__PURE__ */ React__default.createElement("div", null, /* @__PURE__ */ React__default.createElement(
    RadioButtonGroup,
    {
      value: editMode,
      options: [
        { label: t("time-picker.footer.time-zone-option", "Time zone"), value: "tz" },
        { label: t("time-picker.footer.fiscal-year-option", "Fiscal year"), value: "fy" }
      ],
      onChange: setEditMode
    }
  )), editMode === "tz" ? /* @__PURE__ */ React__default.createElement(
    "section",
    {
      "data-testid": selectors.components.TimeZonePicker.containerV2,
      className: cx(style.timeZoneContainer, style.timeSettingContainer)
    },
    /* @__PURE__ */ React__default.createElement(
      TimeZonePicker,
      {
        includeInternal: true,
        onChange: (timeZone2) => {
          onToggleChangeTimeSettings();
          if (isString(timeZone2)) {
            onChangeTimeZone(timeZone2);
          }
        },
        onBlur: onToggleChangeTimeSettings
      }
    )
  ) : /* @__PURE__ */ React__default.createElement(
    "section",
    {
      "aria-label": selectors.components.TimeZonePicker.containerV2,
      className: cx(style.timeZoneContainer, style.timeSettingContainer)
    },
    /* @__PURE__ */ React__default.createElement(
      Field,
      {
        className: style.fiscalYearField,
        label: t("time-picker.footer.fiscal-year-start", "Fiscal year start month")
      },
      /* @__PURE__ */ React__default.createElement(
        Select,
        {
          value: fiscalYearStartMonth,
          menuShouldPortal: false,
          options: monthOptions,
          onChange: (value) => {
            var _a;
            if (onChangeFiscalYearStartMonth) {
              onChangeFiscalYearStartMonth((_a = value.value) != null ? _a : 0);
            }
          }
        }
      )
    )
  )) : null);
};
const getStyle = stylesFactory((theme) => {
  return {
    container: css`
      border-top: 1px solid ${theme.colors.border.weak};
      padding: 11px;
      display: flex;
      flex-direction: row;
      justify-content: space-between;
      align-items: center;
    `,
    editContainer: css`
      border-top: 1px solid ${theme.colors.border.weak};
      padding: 11px;
      justify-content: space-between;
      align-items: center;
      padding: 7px;
    `,
    spacer: css`
      margin-left: 7px;
    `,
    timeSettingContainer: css`
      padding-top: ${theme.spacing(1)};
    `,
    fiscalYearField: css`
      margin-bottom: 0px;
    `,
    timeZoneContainer: css`
      display: flex;
      flex-direction: row;
      justify-content: space-between;
      align-items: center;
      flex-grow: 1;
    `,
    timeZone: css`
      display: flex;
      flex-direction: row;
      align-items: baseline;
      flex-grow: 1;
    `
  };
});

export { TimePickerFooter };
//# sourceMappingURL=TimePickerFooter.js.map
