import { css } from '@emotion/css';
import React__default from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { useStyles2 } from '../../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { Trans } from '../../../utils/i18n.js';
import { Button } from '../../Button/Button.js';
import '../../Button/ButtonGroup.js';
import { TimePickerTitle } from './TimePickerTitle.js';

function Header({ onClose }) {
  const styles = useStyles2(getHeaderStyles);
  return /* @__PURE__ */ React__default.createElement("div", { className: styles.container }, /* @__PURE__ */ React__default.createElement(TimePickerTitle, null, /* @__PURE__ */ React__default.createElement(Trans, { i18nKey: "time-picker.calendar.select-time" }, "Select a time range")), /* @__PURE__ */ React__default.createElement(
    Button,
    {
      "aria-label": selectors.components.TimePicker.calendar.closeButton,
      icon: "times",
      variant: "secondary",
      onClick: onClose
    }
  ));
}
Header.displayName = "Header";
const getHeaderStyles = (theme) => {
  return {
    container: css`
      background-color: ${theme.colors.background.primary};
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 7px;
    `
  };
};

export { Header };
//# sourceMappingURL=CalendarHeader.js.map
