import { css } from '@emotion/css';
import React__default from 'react';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { Icon } from '../Icon/Icon.js';
import { DataLinkButton } from './DataLinkButton.js';

function FieldLinkList({ links }) {
  const styles = useStyles2(getStyles);
  if (links.length === 1) {
    return /* @__PURE__ */ React__default.createElement(DataLinkButton, { link: links[0] });
  }
  const externalLinks = links.filter((link) => link.target === "_blank");
  const internalLinks = links.filter((link) => link.target === "_self");
  return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, internalLinks.map((link, i) => {
    return /* @__PURE__ */ React__default.createElement(DataLinkButton, { key: i, link });
  }), /* @__PURE__ */ React__default.createElement("div", { className: styles.wrapper }, /* @__PURE__ */ React__default.createElement("p", { className: styles.externalLinksHeading }, "External links"), externalLinks.map((link, i) => /* @__PURE__ */ React__default.createElement("a", { key: i, href: link.href, target: link.target, className: styles.externalLink }, /* @__PURE__ */ React__default.createElement(Icon, { name: "external-link-alt" }), link.title))));
}
const getStyles = (theme) => ({
  wrapper: css`
    flex-basis: 150px;
    width: 100px;
    margin-top: ${theme.spacing(1)};
  `,
  externalLinksHeading: css`
    color: ${theme.colors.text.secondary};
    font-weight: ${theme.typography.fontWeightRegular};
    font-size: ${theme.typography.size.sm};
    margin: 0;
  `,
  externalLink: css`
    color: ${theme.colors.text.link};
    font-weight: ${theme.typography.fontWeightRegular};
    display: block;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;

    &:hover {
      text-decoration: underline;
    }

    div {
      margin-right: ${theme.spacing(1)};
    }
  `
});

export { FieldLinkList };
//# sourceMappingURL=FieldLinkList.js.map
