import { css, cx } from '@emotion/css';
import React__default from 'react';
import { useTheme2 } from '../../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';
import { isCompactUrl } from '../../../utils/dataLinks.js';
import { FieldValidationMessage } from '../../Forms/FieldValidationMessage.js';
import { IconButton } from '../../IconButton/IconButton.js';

const DataLinksListItem = ({ link, onEdit, onRemove }) => {
  const theme = useTheme2();
  const styles = getDataLinkListItemStyles(theme);
  const { title = "", url = "" } = link;
  const hasTitle = title.trim() !== "";
  const hasUrl = url.trim() !== "";
  const isCompactExploreUrl = isCompactUrl(url);
  return /* @__PURE__ */ React__default.createElement("div", { className: styles.wrapper }, /* @__PURE__ */ React__default.createElement("div", { className: styles.titleWrapper }, /* @__PURE__ */ React__default.createElement("div", { className: cx(styles.url, !hasUrl && styles.notConfigured, isCompactExploreUrl && styles.errored) }, hasTitle ? title : "Data link title not provided"), /* @__PURE__ */ React__default.createElement("div", { className: styles.actionButtons }, /* @__PURE__ */ React__default.createElement(IconButton, { name: "pen", onClick: onEdit }), /* @__PURE__ */ React__default.createElement(IconButton, { name: "times", onClick: onRemove }))), /* @__PURE__ */ React__default.createElement(
    "div",
    {
      className: cx(styles.url, !hasUrl && styles.notConfigured, isCompactExploreUrl && styles.errored),
      title: url
    },
    hasUrl ? url : "Data link url not provided"
  ), isCompactExploreUrl && /* @__PURE__ */ React__default.createElement(FieldValidationMessage, null, "Explore data link may not work in the future. Please edit."));
};
const getDataLinkListItemStyles = stylesFactory((theme) => {
  return {
    wrapper: css`
      margin-bottom: ${theme.spacing(2)};
      width: 100%;
      &:last-child {
        margin-bottom: 0;
      }
      display: flex;
      flex-direction: column;
    `,
    titleWrapper: css`
      label: data-links-list-item-title;
      justify-content: space-between;
      display: flex;
      width: 100%;
      align-items: center;
    `,
    actionButtons: css`
      margin-left: ${theme.spacing(1)};
      display: flex;
    `,
    errored: css`
      color: ${theme.colors.error.text};
      font-style: italic;
    `,
    notConfigured: css`
      font-style: italic;
    `,
    title: css`
      color: ${theme.colors.text.primary};
      font-size: ${theme.typography.size.sm};
      font-weight: ${theme.typography.fontWeightMedium};
    `,
    url: css`
      color: ${theme.colors.text.secondary};
      font-size: ${theme.typography.size.sm};
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
      max-width: 90%;
    `
  };
});

export { DataLinksListItem };
//# sourceMappingURL=DataLinksListItem.js.map
