import { locationUtil } from './location.js';
import { serializeStateToUrlParam } from './url.js';

const DataLinkBuiltInVars = {
  keepTime: "__url_time_range",
  timeRangeFrom: "__from",
  timeRangeTo: "__to",
  includeVars: "__all_variables",
  seriesName: "__series.name",
  fieldName: "__field.name",
  valueTime: "__value.time",
  valueNumeric: "__value.numeric",
  valueText: "__value.text",
  valueRaw: "__value.raw",
  // name of the calculation represented by the value
  valueCalc: "__value.calc"
};
function mapInternalLinkToExplore(options) {
  var _a, _b;
  const { onClickFn, replaceVariables, link, scopedVars, range, field, internalLink } = options;
  const interpolatedQuery = interpolateObject((_a = link.internal) == null ? void 0 : _a.query, scopedVars, replaceVariables);
  const interpolatedPanelsState = interpolateObject((_b = link.internal) == null ? void 0 : _b.panelsState, scopedVars, replaceVariables);
  const title = link.title ? link.title : internalLink.datasourceName;
  return {
    title: replaceVariables(title, scopedVars),
    // In this case this is meant to be internal link (opens split view by default) the href will also points
    // to explore but this way you can open it in new tab.
    href: generateInternalHref(internalLink.datasourceUid, interpolatedQuery, range, interpolatedPanelsState),
    onClick: onClickFn ? () => {
      onClickFn({
        datasourceUid: internalLink.datasourceUid,
        query: interpolatedQuery,
        panelsState: interpolatedPanelsState,
        range
      });
    } : void 0,
    target: (link == null ? void 0 : link.targetBlank) ? "_blank" : "_self",
    origin: field
  };
}
function generateInternalHref(datasourceUid, query, range, panelsState) {
  return locationUtil.assureBaseUrl(
    `/explore?left=${encodeURIComponent(
      serializeStateToUrlParam({
        range: range.raw,
        datasource: datasourceUid,
        queries: [query],
        panelsState
      })
    )}`
  );
}
function interpolateObject(obj, scopedVars, replaceVariables) {
  if (!obj) {
    return obj;
  }
  if (typeof obj === "string") {
    return replaceVariables(obj, scopedVars);
  }
  const copy = JSON.parse(JSON.stringify(obj));
  return interpolateObjectRecursive(copy, scopedVars, replaceVariables);
}
function interpolateObjectRecursive(obj, scopedVars, replaceVariables) {
  for (const k of Object.keys(obj)) {
    if (typeof obj[k] === "string") {
      obj[k] = replaceVariables(obj[k], scopedVars);
    } else if (typeof obj[k] === "object" && obj[k] !== null) {
      obj[k] = interpolateObjectRecursive(obj[k], scopedVars, replaceVariables);
    }
  }
  return obj;
}

export { DataLinkBuiltInVars, mapInternalLinkToExplore };
//# sourceMappingURL=dataLinks.js.map
