export { LogsDedupStrategy, LogsSortOrder } from '@grafana/schema';

var LogLevel = /* @__PURE__ */ ((LogLevel2) => {
  LogLevel2["emerg"] = "critical";
  LogLevel2["fatal"] = "critical";
  LogLevel2["alert"] = "critical";
  LogLevel2["crit"] = "critical";
  LogLevel2["critical"] = "critical";
  LogLevel2["warn"] = "warning";
  LogLevel2["warning"] = "warning";
  LogLevel2["err"] = "error";
  LogLevel2["eror"] = "error";
  LogLevel2["error"] = "error";
  LogLevel2["info"] = "info";
  LogLevel2["information"] = "info";
  LogLevel2["informational"] = "info";
  LogLevel2["notice"] = "info";
  LogLevel2["dbug"] = "debug";
  LogLevel2["debug"] = "debug";
  LogLevel2["trace"] = "trace";
  LogLevel2["unknown"] = "unknown";
  return LogLevel2;
})(LogLevel || {});
var LogsMetaKind = /* @__PURE__ */ ((LogsMetaKind2) => {
  LogsMetaKind2[LogsMetaKind2["Number"] = 0] = "Number";
  LogsMetaKind2[LogsMetaKind2["String"] = 1] = "String";
  LogsMetaKind2[LogsMetaKind2["LabelsMap"] = 2] = "LabelsMap";
  LogsMetaKind2[LogsMetaKind2["Error"] = 3] = "Error";
  return LogsMetaKind2;
})(LogsMetaKind || {});
var LogsDedupDescription = /* @__PURE__ */ ((LogsDedupDescription2) => {
  LogsDedupDescription2["none"] = "No de-duplication";
  LogsDedupDescription2["exact"] = "De-duplication of successive lines that are identical, ignoring ISO datetimes.";
  LogsDedupDescription2["numbers"] = "De-duplication of successive lines that are identical when ignoring numbers, e.g., IP addresses, latencies.";
  LogsDedupDescription2["signature"] = "De-duplication of successive lines that have identical punctuation and whitespace.";
  return LogsDedupDescription2;
})(LogsDedupDescription || {});
const hasLogsContextSupport = (datasource) => {
  if (!datasource) {
    return false;
  }
  const withLogsSupport = datasource;
  return withLogsSupport.getLogRowContext !== void 0 && withLogsSupport.showContextToggle !== void 0;
};
var SupplementaryQueryType = /* @__PURE__ */ ((SupplementaryQueryType2) => {
  SupplementaryQueryType2["LogsVolume"] = "LogsVolume";
  SupplementaryQueryType2["LogsSample"] = "LogsSample";
  return SupplementaryQueryType2;
})(SupplementaryQueryType || {});
var LogsVolumeType = /* @__PURE__ */ ((LogsVolumeType2) => {
  LogsVolumeType2["FullRange"] = "FullRange";
  LogsVolumeType2["Limited"] = "Limited";
  return LogsVolumeType2;
})(LogsVolumeType || {});
const getLogsVolumeAbsoluteRange = (dataFrames, defaultRange) => {
  var _a, _b;
  return ((_b = (_a = dataFrames[0].meta) == null ? void 0 : _a.custom) == null ? void 0 : _b.absoluteRange) || defaultRange;
};
const getLogsVolumeDataSourceInfo = (dataFrames) => {
  var _a, _b;
  const customMeta = (_b = (_a = dataFrames[0]) == null ? void 0 : _a.meta) == null ? void 0 : _b.custom;
  if (customMeta && customMeta.datasourceName) {
    return {
      name: customMeta.datasourceName
    };
  }
  return null;
};
const isLogsVolumeLimited = (dataFrames) => {
  var _a, _b, _c;
  return ((_c = (_b = (_a = dataFrames[0]) == null ? void 0 : _a.meta) == null ? void 0 : _b.custom) == null ? void 0 : _c.logsVolumeType) === "Limited" /* Limited */;
};
const hasSupplementaryQuerySupport = (datasource, type) => {
  if (!datasource) {
    return false;
  }
  const withSupplementaryQueriesSupport = datasource;
  return withSupplementaryQueriesSupport.getDataProvider !== void 0 && withSupplementaryQueriesSupport.getSupplementaryQuery !== void 0 && withSupplementaryQueriesSupport.getSupportedSupplementaryQueryTypes().includes(type);
};
const hasLogsContextUiSupport = (datasource) => {
  if (!datasource) {
    return false;
  }
  const withLogsSupport = datasource;
  return withLogsSupport.getLogRowContextUi !== void 0;
};

export { LogLevel, LogsDedupDescription, LogsMetaKind, LogsVolumeType, SupplementaryQueryType, getLogsVolumeAbsoluteRange, getLogsVolumeDataSourceInfo, hasLogsContextSupport, hasLogsContextUiSupport, hasSupplementaryQuerySupport, isLogsVolumeLimited };
//# sourceMappingURL=logs.js.map
