import { map } from 'rxjs/operators';
import { ArrayVector } from '../../vector/ArrayVector.js';
import { DataTransformerID } from './ids.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const DEFAULT_LIMIT_FIELD = 10;
const limitTransformer = {
  id: DataTransformerID.limit,
  name: "Limit",
  description: "Limit the number of items to the top N",
  defaultOptions: {
    limitField: DEFAULT_LIMIT_FIELD
  },
  operator: (options) => (source) => source.pipe(
    map((data) => {
      const limitFieldMatch = options.limitField || DEFAULT_LIMIT_FIELD;
      return data.map((frame) => {
        if (frame.length > limitFieldMatch) {
          return __spreadProps(__spreadValues({}, frame), {
            fields: frame.fields.map((f) => {
              const vals = f.values.toArray();
              return __spreadProps(__spreadValues({}, f), {
                values: new ArrayVector(vals.slice(0, limitFieldMatch))
              });
            }),
            length: limitFieldMatch
          });
        }
        return frame;
      });
    })
  )
};

export { limitTransformer };
//# sourceMappingURL=limit.js.map
