function createSpacing(options = {}) {
  const { gridSize = 8 } = options;
  const transform = (value) => {
    if (typeof value === "string") {
      return value;
    }
    if (process.env.NODE_ENV !== "production") {
      if (typeof value !== "number") {
        console.error(`Expected spacing argument to be a number or a string, got ${value}.`);
      }
    }
    return value * gridSize;
  };
  const spacing = (...args) => {
    if (process.env.NODE_ENV !== "production") {
      if (!(args.length <= 4)) {
        console.error(`Too many arguments provided, expected between 0 and 4, got ${args.length}`);
      }
    }
    if (args.length === 0) {
      args[0] = 1;
    }
    return args.map((argument) => {
      const output = transform(argument);
      return typeof output === "number" ? `${output}px` : output;
    }).join(" ");
  };
  spacing.gridSize = gridSize;
  return spacing;
}

export { createSpacing };
//# sourceMappingURL=createSpacing.js.map
