import { useState, useEffect, useLayoutEffect } from 'react';
import { pluginLog } from '../utils.js';

const MIN_ZOOM_DIST = 5;
const ZoomPlugin = ({ onZoom, config }) => {
  const [selection, setSelection] = useState(null);
  useEffect(() => {
    if (selection) {
      pluginLog("ZoomPlugin", false, "selected", selection);
      if (selection.bbox.width < MIN_ZOOM_DIST) {
        return;
      }
      onZoom({ from: selection.min, to: selection.max });
    }
  }, [selection]);
  useLayoutEffect(() => {
    config.addHook("setSelect", (u) => {
      const min = u.posToVal(u.select.left, "x");
      const max = u.posToVal(u.select.left + u.select.width, "x");
      setSelection({
        min,
        max,
        bbox: {
          left: u.bbox.left / window.devicePixelRatio + u.select.left,
          top: u.bbox.top / window.devicePixelRatio,
          height: u.bbox.height / window.devicePixelRatio,
          width: u.select.width
        }
      });
      u.setSelect({ left: 0, width: 0 }, false);
    });
  }, [config]);
  return null;
};

export { ZoomPlugin };
//# sourceMappingURL=ZoomPlugin.js.map
