import { cx, css } from '@emotion/css';
import React__default, { useCallback } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { VizLegendSeriesIcon } from './VizLegendSeriesIcon.js';
import { VizLegendStatsList } from './VizLegendStatsList.js';

const VizLegendListItem = ({
  item,
  onLabelClick,
  onLabelMouseOver,
  onLabelMouseOut,
  className,
  readonly
}) => {
  const styles = useStyles2(getStyles);
  const onMouseOver = useCallback(
    (event) => {
      if (onLabelMouseOver) {
        onLabelMouseOver(item, event);
      }
    },
    [item, onLabelMouseOver]
  );
  const onMouseOut = useCallback(
    (event) => {
      if (onLabelMouseOut) {
        onLabelMouseOut(item, event);
      }
    },
    [item, onLabelMouseOut]
  );
  const onClick = useCallback(
    (event) => {
      if (onLabelClick) {
        onLabelClick(item, event);
      }
    },
    [item, onLabelClick]
  );
  return /* @__PURE__ */ React__default.createElement(
    "div",
    {
      className: cx(styles.itemWrapper, item.disabled && styles.itemDisabled, className),
      "aria-label": selectors.components.VizLegend.seriesName(item.label)
    },
    /* @__PURE__ */ React__default.createElement(VizLegendSeriesIcon, { seriesName: item.label, color: item.color, gradient: item.gradient, readonly }),
    /* @__PURE__ */ React__default.createElement(
      "button",
      {
        disabled: readonly,
        type: "button",
        onBlur: onMouseOut,
        onFocus: onMouseOver,
        onMouseOver,
        onMouseOut,
        onClick,
        className: styles.label
      },
      item.label
    ),
    item.getDisplayValues && /* @__PURE__ */ React__default.createElement(VizLegendStatsList, { stats: item.getDisplayValues() })
  );
};
VizLegendListItem.displayName = "VizLegendListItem";
const getStyles = (theme) => ({
  label: css`
    label: LegendLabel;
    white-space: nowrap;
    background: none;
    border: none;
    font-size: inherit;
    padding: 0;
    user-select: text;
  `,
  itemDisabled: css`
    label: LegendLabelDisabled;
    color: ${theme.colors.text.disabled};
  `,
  itemWrapper: css`
    label: LegendItemWrapper;
    display: flex;
    white-space: nowrap;
    align-items: center;
    flex-grow: 1;
  `,
  value: css`
    text-align: right;
  `,
  yAxisLabel: css`
    color: ${theme.v1.palette.gray2};
  `
});

export { VizLegendListItem };
//# sourceMappingURL=VizLegendListItem.js.map
