import React__default, { useRef, useCallback, useEffect } from 'react';
import { usePopperTooltip } from 'react-popper-tooltip';
import { useStyles2 } from '../../themes/ThemeContext.js';
import { buildTooltipTheme } from '../../utils/tooltipUtils.js';
import { IconButton } from '../IconButton/IconButton.js';
import { Portal } from '../Portal/Portal.js';

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
const Toggletip = React__default.memo(
  ({
    children,
    theme = "info",
    placement = "auto",
    content,
    title,
    closeButton = true,
    onClose,
    footer
  }) => {
    const styles = useStyles2(getStyles);
    const style = styles[theme];
    const contentRef = useRef(null);
    const [controlledVisible, setControlledVisible] = React__default.useState(false);
    const closeToggletip = useCallback(() => {
      setControlledVisible(false);
      onClose == null ? void 0 : onClose();
    }, [onClose]);
    useEffect(() => {
      if (controlledVisible) {
        const handleKeyDown = (enterKey) => {
          if (enterKey.key === "Escape") {
            closeToggletip();
          }
        };
        document.addEventListener("keydown", handleKeyDown);
        return () => {
          document.removeEventListener("keydown", handleKeyDown);
        };
      }
      return;
    }, [controlledVisible, closeToggletip]);
    const { getArrowProps, getTooltipProps, setTooltipRef, setTriggerRef, visible, update } = usePopperTooltip({
      visible: controlledVisible,
      placement,
      interactive: true,
      offset: [0, 8],
      trigger: "click",
      onVisibleChange: (value) => {
        setControlledVisible(value);
        if (!value) {
          onClose == null ? void 0 : onClose();
        }
      }
    });
    return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, React__default.cloneElement(children, {
      ref: setTriggerRef,
      tabIndex: 0
    }), visible && /* @__PURE__ */ React__default.createElement(Portal, null, /* @__PURE__ */ React__default.createElement(
      "div",
      __spreadValues({
        "data-testid": "toggletip-content",
        ref: setTooltipRef
      }, getTooltipProps({ className: style.container })),
      Boolean(title) && /* @__PURE__ */ React__default.createElement("div", { className: style.header }, title),
      closeButton && /* @__PURE__ */ React__default.createElement("div", { className: style.headerClose }, /* @__PURE__ */ React__default.createElement(
        IconButton,
        {
          "aria-label": "Close Toggletip",
          name: "times",
          size: "md",
          "data-testid": "toggletip-header-close",
          onClick: closeToggletip
        }
      )),
      /* @__PURE__ */ React__default.createElement("div", __spreadValues({ ref: contentRef }, getArrowProps({ className: style.arrow }))),
      /* @__PURE__ */ React__default.createElement("div", { className: style.body }, (typeof content === "string" || React__default.isValidElement(content)) && content, typeof content === "function" && update && content({ update })),
      Boolean(footer) && /* @__PURE__ */ React__default.createElement("div", { className: style.footer }, footer)
    )));
  }
);
Toggletip.displayName = "Toggletip";
const getStyles = (theme) => {
  const info = buildTooltipTheme(
    theme,
    theme.components.tooltip.background,
    theme.components.tooltip.background,
    theme.components.tooltip.text,
    { topBottom: 3, rightLeft: 3 }
  );
  const error = buildTooltipTheme(
    theme,
    theme.colors.error.main,
    theme.colors.error.main,
    theme.colors.error.contrastText,
    { topBottom: 3, rightLeft: 3 }
  );
  return {
    info,
    error
  };
};

export { Toggletip, getStyles };
//# sourceMappingURL=Toggletip.js.map
