import { cx, css } from '@emotion/css';
import React__default from 'react';
import { useTheme2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';
import { sharedInputStyle, getFocusStyle } from '../Forms/commonStyles.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const TextArea = React__default.forwardRef((_a, ref) => {
  var _b = _a, { invalid, className } = _b, props = __objRest(_b, ["invalid", "className"]);
  const theme = useTheme2();
  const styles = getTextAreaStyle(theme, invalid);
  return /* @__PURE__ */ React__default.createElement("textarea", __spreadProps(__spreadValues({}, props), { className: cx(styles.textarea, className), ref }));
});
const getTextAreaStyle = stylesFactory((theme, invalid = false) => {
  return {
    textarea: cx(
      sharedInputStyle(theme),
      getFocusStyle(theme),
      css`
        border-radius: ${theme.shape.borderRadius()};
        padding: ${theme.spacing.gridSize / 4}px ${theme.spacing.gridSize}px;
        width: 100%;
        border-color: ${invalid ? theme.colors.error.border : theme.components.input.borderColor};
      `
    )
  };
});
TextArea.displayName = "TextArea";

export { TextArea };
//# sourceMappingURL=TextArea.js.map
