const TableCell = ({ cell, tableStyles, onCellFilterAdded, userProps }) => {
  var _a;
  const cellProps = cell.getCellProps();
  const field = cell.column.field;
  if (!(field == null ? void 0 : field.display)) {
    return null;
  }
  if (cellProps.style) {
    cellProps.style.minWidth = cellProps.style.width;
    cellProps.style.justifyContent = cell.column.justifyContent;
  }
  let innerWidth = ((_a = cell.column.width) != null ? _a : 24) - tableStyles.cellPadding * 2;
  return cell.render("Cell", {
    field,
    tableStyles,
    onCellFilterAdded,
    cellProps,
    innerWidth,
    userProps
  });
};

export { TableCell };
//# sourceMappingURL=TableCell.js.map
