import { css } from '@emotion/css';
import React__default, { useState } from 'react';
import { useTheme2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';
import { TabsBar } from '../Tabs/TabsBar.js';
import { Tab } from '../Tabs/Tab.js';
import { IconButton } from '../IconButton/IconButton.js';
import { CustomScrollbar } from '../CustomScrollbar/CustomScrollbar.js';
import { TabContent } from '../Tabs/TabContent.js';

const getStyles = stylesFactory((theme) => {
  return {
    container: css`
      height: 100%;
    `,
    tabContent: css`
      padding: ${theme.spacing(2)};
      background-color: ${theme.colors.background.primary};
      height: calc(100% - ${theme.components.menuTabs.height}px);
    `,
    close: css`
      position: absolute;
      right: 16px;
      top: 5px;
      cursor: pointer;
      font-size: ${theme.typography.size.lg};
    `,
    tabs: css`
      padding-top: ${theme.spacing(1)};
      border-color: ${theme.colors.border.weak};
      ul {
        margin-left: ${theme.spacing(2)};
      }
    `
  };
});
function TabbedContainer(props) {
  var _a, _b;
  const [activeTab, setActiveTab] = useState(
    props.tabs.some((tab) => tab.value === props.defaultTab) ? props.defaultTab : (_a = props.tabs) == null ? void 0 : _a[0].value
  );
  const onSelectTab = (item) => {
    setActiveTab(item.value);
  };
  const { tabs, onClose, closeIconTooltip } = props;
  const theme = useTheme2();
  const styles = getStyles(theme);
  return /* @__PURE__ */ React__default.createElement("div", { className: styles.container }, /* @__PURE__ */ React__default.createElement(TabsBar, { className: styles.tabs }, tabs.map((t) => /* @__PURE__ */ React__default.createElement(
    Tab,
    {
      key: t.value,
      label: t.label,
      active: t.value === activeTab,
      onChangeTab: () => onSelectTab(t),
      icon: t.icon
    }
  )), /* @__PURE__ */ React__default.createElement(IconButton, { className: styles.close, onClick: onClose, name: "times", title: closeIconTooltip != null ? closeIconTooltip : "Close" })), /* @__PURE__ */ React__default.createElement(CustomScrollbar, { autoHeightMin: "100%" }, /* @__PURE__ */ React__default.createElement(TabContent, { className: styles.tabContent }, (_b = tabs.find((t) => t.value === activeTab)) == null ? void 0 : _b.content)));
}

export { TabbedContainer };
//# sourceMappingURL=TabbedContainer.js.map
